% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_units.R
\name{append_units.default}
\alias{append_units.default}
\title{Append Units By Default}
\usage{
\method{append_units}{default}(
  x,
  ...,
  open = getOption("yamlet_append_units_open", " ("),
  close = getOption("yamlet_append_units_close", ")"),
  style = getOption("yamlet_append_units_style", "plain"),
  target = getOption("yamlet_append_units_target", "label")
)
}
\arguments{
\item{x}{object}

\item{...}{passed to \code{\link[spork]{as_latex}}, \code{\link[spork]{as_plotmath}}}

\item{open}{character to precede units}

\item{close}{character to follow units}

\item{style}{one of 'plain', 'latex', or 'plotmath'}

\item{target}{attribute name for appended result}
}
\value{
same class as x, with sub-class 'latex' or 'plotmath' depending on \code{style}
}
\description{
Units attribute is wrapped in \code{open} and
\code{close}, and appended to label.
Result is assigned to \code{target} attribute
(default: 'label').
If style is 'latex' or 'plotmath',
all elements are treated as spork
(\code{\link[spork]{as_spork}}) and coerced
to canonical form before concatenation.
}
\examples{
library(units)
library(magrittr)
x <- 1:10
attr(x, 'label') <- 'acceleration'
units(x) <- 'm/s^2'
y <- as_units('kg')
x \%>\% attr('label')
x \%>\% append_units \%>\% attr('label')
y \%>\% attr('label')
y \%>\% append_units \%>\% attr('label')
x \%>\% append_units(style = 'plain')
x \%>\% append_units(style = 'plotmath')
x \%>\% append_units(style = 'latex')


}
\seealso{
Other labels: 
\code{\link{alias.data.frame}()},
\code{\link{append_units}()},
\code{\link{append_units.data.frame}()},
\code{\link{drop_title}()},
\code{\link{drop_title.decorated}()},
\code{\link{drop_title.default}()},
\code{\link{drop_title.dvec}()},
\code{\link{make_title}()},
\code{\link{make_title.decorated}()},
\code{\link{make_title.default}()},
\code{\link{make_title.dvec}()},
\code{\link{sub_units}()}
}
\concept{labels}
\keyword{internal}
