% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinPermTest.R
\name{coinPermTest}
\alias{coinPermTest}
\title{Compare Means Of Two Vectors By Permutation Test}
\usage{
coinPermTest(
  x1,
  x2,
  orient = "two.sided",
  nPerm = 5000,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x1}{numeric vector (to be compared with vector 'x2')}

\item{x2}{numeric vector (to be compared with vector 'x1')}

\item{orient}{(character) may be "two.sided","greater" or "less"}

\item{nPerm}{(integer) number of permutations}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns an object of "MCp" class numeric output with p-values
}
\description{
Run coin-flipping like permutation tests (to compare difference of 2 means: 'x1' and 'x2') without any distribution-assumptions.
This function uses the package \href{https://CRAN.R-project.org/package=coin}{coin}, if not installed, the function will return NULL and give a warning.
}
\examples{
coinPermTest(2, 3, nPerm=200)
}
\seealso{
\code{oneway_test} in \code{\link[coin]{LocationTests}}
}
