#' @keywords internal
#'
#' @details This package contains functions to import surface meteorological
#'   data from over 30,000 sites around the world. These data are curated by
#'   NOAA as part of the Integrated Surface Database (ISD).
#'
#'   If you access these data using the `worldmet` package please give full
#'   acknowledgement to NOAA ISD. Users should also take a note of the usage
#'   restrictions.
#'
#'   These data work well with the `openair` package that has been developed to
#'   analyse air pollution data.
#'
#' @references For general information of the ISD see
#'   <https://www.ncei.noaa.gov/products/land-based-station/integrated-surface-database>
#'    and the map here <https://gis.ncdc.noaa.gov/maps/ncei>.
#'
#' @seealso See <https://github.com/openair-project/openair> for information on the
#'   related `openair` package.
"_PACKAGE"
## usethis namespace: start
#' @importFrom rlang .data
## usethis namespace: end
NULL
