% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_season_team_stats.R
\name{fb_season_team_stats}
\alias{fb_season_team_stats}
\title{Get FBref season team stats}
\usage{
fb_season_team_stats(
  country,
  gender,
  season_end_year,
  tier,
  stat_type,
  time_pause = 3
)
}
\arguments{
\item{country}{the three character country code for all countries}

\item{gender}{gender of competition, either "M", "F" or both}

\item{season_end_year}{the year the season(s) concludes}

\item{tier}{the tier of the league, ie '1st' for the EPL or '2nd' for the Championship and so on}

\item{stat_type}{the type of team statistics the user requires}

\item{time_pause}{the wait time (in seconds) between page loads

The statistic type options (stat_type) include:

\emph{"league_table"}, \emph{"league_table_home_away}", \emph{"standard"},
\emph{"keeper"}, \emph{"keeper_adv"}, \emph{"shooting"}, \emph{"passing"},
\emph{"passing_types"}, \emph{"goal_shot_creation"}, \emph{"defense" },
\emph{"possession"}, \emph{"playing_time"}, \emph{"misc"}}
}
\value{
returns a dataframe of a selected team statistic type for a selected league season
}
\description{
Returns different team season statistics results for a given league season and stat type
Replaces the deprecated function get_season_team_stats
}
\examples{
\dontrun{
try({
fb_season_team_stats("ITA", "M", 2021, "1st", "defense")
})
}
}
