% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_match_urls.R
\name{fb_match_urls}
\alias{fb_match_urls}
\title{Get FBref match URLs}
\usage{
fb_match_urls(
  country,
  gender,
  season_end_year,
  tier = "1st",
  non_dom_league_url = NA,
  time_pause = 3
)
}
\arguments{
\item{country}{the three character country code}

\item{gender}{gender of competition, either "M" or "F", or both}

\item{season_end_year}{the year the season(s) concludes}

\item{tier}{the tier of the league, ie '1st' for the EPL or '2nd' for the Championship and so on}

\item{non_dom_league_url}{the URL for Cups and Competitions found at https://fbref.com/en/comps/}

\item{time_pause}{the wait time (in seconds) between page loads}
}
\value{
returns a character vector of all fbref match URLs for selected competition, season and gender
}
\description{
Returns the URL for each match played for a given league season
Replaces the deprecated get_match_urls
}
\examples{
\dontrun{
try({
fb_match_urls(country = "ENG", gender = "M", season_end_year = c(2019:2021), tier = "1st")
non_dom <- "https://fbref.com/en/comps/218/history/Friendlies-M-Seasons"
fb_match_urls(country = "", gender = "M", season_end_year = 2021, non_dom_league_url = non_dom)
})
}
}
