% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.thread.reddit.R, R/zzz.R
\name{Collect.thread.reddit}
\alias{Collect.thread.reddit}
\alias{collect_reddit_threads}
\title{Collect comments data from reddit threads}
\usage{
\method{Collect}{thread.reddit}(
  credential,
  endpoint,
  threadUrls,
  sort = NA,
  waitTime = c(6, 8),
  ua = NULL,
  ...,
  writeToFile = FALSE,
  verbose = TRUE
)

collect_reddit_threads(
  threadUrls,
  sort = "best",
  waitTime = c(6, 8),
  ua = vsml_ua(),
  writeToFile = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"reddit"}.}

\item{endpoint}{API endpoint.}

\item{threadUrls}{Character vector. Reddit thread urls to collect data from.}

\item{sort}{Character vector. Reddit comment sort order. Options are \code{"best"}, \code{"top"}, \code{"new"},
\code{"controversial"}, \code{"old"}, and \code{"qa"}. Default is \code{NA}.}

\item{waitTime}{Numeric vector. Time range in seconds to select random wait from in-between url collection requests.
Minimum is 3 seconds. Default is \code{c(6, 8)} for a wait time chosen from between 6 and 8 seconds.}

\item{ua}{Character string. Override User-Agent string to use in Reddit thread requests. Default is \code{NULL}.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information about the data collection. Default is \code{TRUE}.}
}
\value{
A \code{tibble} object with class names \code{"datasource"} and \code{"reddit"}.
}
\description{
Collects comments made by users on one or more specified subreddit conversation threads and structures
the data into a dataframe with the class names \code{"datasource"} and \code{"reddit"}.
}
\note{
The reddit web endpoint used for collection has maximum limit of 500 comments per thread url.
}
\examples{
\dontrun{
# subreddit url to collect threads from
threadUrls <- c("https://www.reddit.com/r/xxxxxx/comments/xxxxxx/x_xxxx_xxxxxxxxx/")

redditData <- redditAuth |>
  Collect(threadUrls = threadUrls, writeToFile = TRUE)
}

}
