% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_mistnet_from_file}
\alias{install_mistnet_from_file}
\title{Install 'MistNet' libraries from files}
\usage{
install_mistnet_from_file(
  version = "1.12.1",
  libtorch,
  libmistnet,
  mistnet_model = NULL,
  ...
)
}
\arguments{
\item{version}{The 'LibTorch' version to install.}

\item{libtorch}{The installation archive file to use for 'LibTorch'. Shall be a \code{"file://"} URL scheme.}

\item{libmistnet}{The installation archive file to use for 'MistNet'. Shall be a \code{"file://"} URL scheme.}

\item{mistnet_model}{The installation archive file to use for the model. Shall be a \code{"file://"} URL scheme. Is optional!}

\item{...}{other parameters to be passed to \code{install_torch()}}
}
\value{
a list with character urls
}
\description{
Installs 'LibTorch' and 'MistNet' dependencies from files.
}
\details{
When \code{\link[=install_mistnet]{install_mistnet()}} initiated download is not possible, but installation archive files are
present on local filesystem, \code{\link[=install_mistnet_from_file]{install_mistnet_from_file()}} can be used as a workaround to installation issues.
\code{"libtorch"} is the archive containing all 'LibTorch' modules, and \code{"libmistnet"} is the 'C' interface to 'LibTorch'
that is used for the 'R' package. Both are highly platform dependent, and should be checked through \code{\link[=get_install_urls]{get_install_urls()}}

\if{html}{\out{<div class="sourceCode R">}}\preformatted{> get_install_urls()
$libtorch
[1] "https://download.pytorch.org/libtorch/cpu/libtorch-cxx11-abi-shared-with-deps-1.10.2\%2Bcpu.zip"

$libmistnet
[1] "https://s3.amazonaws.com/vol2bird-builds/vol2birdr/refs/heads/main/latest/Linux-cpu.zip"

$mistnet_model
[1] "http://mistnet.s3.amazonaws.com/mistnet_nexrad.pt"
}\if{html}{\out{</div>}}

In a terminal, download above zip-files.

\if{html}{\out{<div class="sourceCode R">}}\preformatted{\%> mkdir /tmp/myfiles
\%> cd /tmp/myfiles
\%> wget https://download.pytorch.org/libtorch/cpu/libtorch-cxx11-abi-shared-with-deps-1.10.2\%2Bcpu.zip
\%> wget https://s3.amazonaws.com/vol2bird-builds/vol2birdr/refs/heads/main/latest/Linux-cpu.zip
\%> wget http://mistnet.s3.amazonaws.com/mistnet_nexrad.pt
}\if{html}{\out{</div>}}

Then in R, type:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{> install_mistnet_from_file(libtorch="file:///tmp/myfiles/libtorch-cxx11-abi-shared-with-deps-1.10.2+cpu.zip",
     libmistnet="file:///tmp/myfiles/Linux-cpu.zip",
     mistnet_model="file:///tmp/myfiles/mistnet_nexrad.pt")
}\if{html}{\out{</div>}}
}
\examples{
# get paths to files to be downloaded
get_install_urls()
# download the files to a directory on disk, e.g. to /tmp/myfile,
# then install with:
\dontrun{
install_mistnet_from_file(
     libtorch="file:///tmp/myfiles/libtorch-cxx11-abi-shared-with-deps-1.10.2+cpu.zip",
     libmistnet="file:///tmp/myfiles/Linux-cpu.zip",
     mistnet_model="file:///tmp/myfiles/mistnet_nexrad.pt")
}

}
\seealso{
\itemize{
\item \code{\link[=install_mistnet]{install_mistnet()}}
}
}
