% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spn2abc.R
\name{spn2abc}
\alias{spn2abc}
\title{Convert SPN to ABC}
\usage{
spn2abc(x, to_lower = FALSE, spacing = TRUE)
}
\arguments{
\item{x}{A vector containing a note in SPN (Scientific Pitch Notation).}

\item{to_lower}{Logical. Should the string be lower case? Default: \code{FALSE}.}

\item{spacing}{Logical. Should the strin return spaces between notes? Default: \code{TRUE}.}
}
\description{
Convert SPN to standard octave.
}
\examples{
library(voice)
spn2abc('C4')
spn2abc('C5')
spn2abc('C4', to_lower = TRUE)
spn2abc(c('C4','D#7','E2'))
spn2abc(c('C4','D#7','E2'), to_lower = TRUE)
spn2abc(c('C4','D#7','E2'), spacing = FALSE)
spn2abc(c('C4','D#7','E2'), to_lower = TRUE, spacing = FALSE)
}
\references{
https://en.wikipedia.org/wiki/Scientific_pitch_notation

https://en.wikipedia.org/wiki/ABC_notation
}
