% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_notes.R
\name{assign_notes}
\alias{assign_notes}
\title{Assign musical notes}
\usage{
assign_notes(
  x,
  fmt = 0,
  min_points = 4,
  min_percentile = 0.75,
  max_na_prop = 1
)
}
\arguments{
\item{x}{Media dataset from voice::extract_features().}

\item{fmt}{Either F0 or formant frequency (in Hz). Default: \code{fmt = 0}.}

\item{min_points}{Minimum number of points for audio section. Default: \code{min_points = 4}.}

\item{min_percentile}{Minimum percentile value of gain to be included on the average of \code{fmt}. Default: \code{min_percentile = 0.75}.}

\item{max_na_prop}{Maximum proportion os NAs on gain sector. Default: \code{max_na_prop = 1}.}
}
\description{
Assign musical notes in Scientific Pitch Notation or other variant. See \code{voice::notes()}. The notes are cut considering f0 to ensure alignment.
}
\examples{
library(voice)
# get path to audio file
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern = glob2rx('*.wav'), full.names = TRUE)
# Media dataset
M <- extract_features(path2wav)
assign_notes(M, fmt = 0) # f0
assign_notes(M, fmt = 1) # f1
assign_notes(M, fmt = 2) # f2
}
