% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n.check.data.R
\name{n.check.data}
\alias{n.check.data}
\title{Check the format of multivariate time series}
\usage{
n.check.data(y, x = NULL)
}
\arguments{
\item{y}{time series y in matrix format (\code{m} rows x 2 columns). The
first column should contain the time steps and the second column should
contain the values.}

\item{x}{multivariate time series x in matrix format (\code{m} rows x (1 + (n-1)) columns). The
first column should contain the time steps and the other columns should
contain the values.}
}
\value{
Returns a named list containing:
\item{t}{time steps}
\item{dt}{size of a time step}
\item{n.obs}{number of observations}
}
\description{
Check the format of multivariate time series
}
\examples{
#Example 1:
t1 <- cbind(1:100, rnorm(100))
n.check.data(y = t1)

#Example 2:
t1 <- cbind(1:100, rnorm(100))
t2 <- cbind(1:100, rnorm(100), rnorm(100), rnorm(100))
n.check.data(y = t1, x = t2)


}
\author{
Tunc Oygur (info@tuncoygur.com.tr)

Code based on biwavelet package written by Tarik C. Gouhier.
}
