% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_misc.R
\name{table.from.phi}
\alias{table.from.phi}
\title{Computes the cell frequencies in a 2x2 table using the marginal proportions
and phi correlation}
\usage{
table.from.phi(p1row, p1col, phi, n)
}
\arguments{
\item{p1row}{marginal proportion for row 1}

\item{p1col}{marginal proportion for column 1}

\item{phi}{estimated phi correlation}

\item{n}{total sample size}
}
\value{
A 2-row matrix. The rows are:
\itemize{
\item Row 1 gives the four computed cell proportions
\item Row 2 gives the four computed cell frequencies
}

The columns are:
\itemize{
\item cell 11 - proportion and frequency for cell 11
\item cell 12 - proportion and frequency for cell 12
\item cell 21 - proportion and frequency for cell 21
\item cell 22 - proportion and frequency for cell 22
}
}
\description{
This function computes the cell proportions and frequencies in a 2x2
contingency table using the reported marginal proportions, estimated phi
correlation, and total sample size. The cell frequncies could then be used
to compute other measures of effect size. In the output, "cell ij" refers
to row i and column j.
}
\examples{
table.from.phi(.28, .64, .38, 200)

# Should return:
#                cell 11   cell 12    cell 21    cell 22
# Proportion:  0.2610974 0.0189026  0.3789026  0.3410974
# Frequency   52.0000000 4.0000000 76.0000000 68.0000000


}
