% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.semipart}
\alias{se.semipart}
\title{Computes the standard error for a semipartial correlation}
\usage{
se.semipart(cor, r2, n)
}
\arguments{
\item{cor}{estimated semipartial correlation}

\item{r2}{estimated squared multiple correlation for a model that
includes the IV and all control variables}

\item{n}{sample size}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - semipartial correlation (from input)
\item SE - standard error
}
}
\description{
Computes the standard error of a semipartial correlation using the
estimated correlation, sample size, and squared multiple correlation
for the full model. The full model includes the independent variable
of interest and all control variables. The effect size estimate and
standard error output from this function can be used as input in the
\link[vcmeta]{meta.ave.cor.gen} function in applications where a
combination of different types of compatible correlations are used
in the meta-analysis.
}
\examples{
se.semipart(.40, .25, 60)

# Should return: 
#                           Estimate        SE
# Semipartial correlation:       0.4 0.1063262


}
