% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-info.R
\name{vapour_sds_names}
\alias{vapour_sds_names}
\title{GDAL raster subdatasets (variables)}
\usage{
vapour_sds_names(x)
}
\arguments{
\item{x}{a data source string, filename, database connection string,  or other URL}
}
\value{
character vector of subdataset names, or just the source itself if no SDS are present
}
\description{
A \strong{subdataset} is a collection abstraction for a number of \strong{variables}
within a single GDAL source. If there's only one variable the datasource and
the variable have the same data source string. If there is more than one the
subdatasets have the form \strong{DRIVER:"datasourcename":varname}. Each
subdataset name can stand in place of a data source name that has only one
variable, so we always treat a source as a subdataset, even if there's only
one.
}
\details{
Returns a character vector of 'subdatasets\verb{. In the case of a normal data source, with no subdatasets the value is simply  the }datasource`.

If the raw SDS names contain spaces these are replaced by '\%20' escape strings. A specific example is
"WCS:https://elevation.nationalmap.gov:443" with request
"arcgis/services/3DEPElevation/ImageServer/WCSServer?version=2.0.1&coverage=DEP3Elevation_Hillshade Gray".
This function will return "..DEP3Elevation_Hillshade\%20Gray".
See \href{https://github.com/hypertidy/vapour/wiki/Examples-of-subdatasets}{wiki post} for more details.
}
\examples{
f <- system.file("extdata/gdal", "sds.nc", package = "vapour")
## protect from error with netcdf problems
result <- try(vapour_sds_names(f), silent = TRUE)
if (!inherits(result, "try-error")) {
  print(result)
}
vapour_sds_names(system.file("extdata", "sst.tif", package = "vapour"))

}
