% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utest.R
\name{utest}
\alias{utest}
\title{Perform Utest}
\usage{
utest(lmObject, vars, .vcov = NULL, x.min = NULL, x.max = NULL)
}
\arguments{
\item{lmObject}{The model to be tested}

\item{vars}{A vector with the name of the linear and squared terms. Can also be provided as a formula}

\item{.vcov}{The covariance matrix to use}

\item{x.min}{Lower bound of interval. If \code{NULL}, the minimum observed in the data is used.}

\item{x.max}{Upper bound of interval. If \code{NULL}, the maximum observed in the data is used.}
}
\value{
A list with class "htest" containing the following components:
\item{\code{statistic    }}{the test statistic.}
\item{\code{p.value      }}{the p-value for the test.}
\item{\code{method       }}{a character string indicating what type of test was performed.}
\item{\code{data.name    }}{a character string giving the name(s) of the data.}
\item{\code{alternative  }}{a character string describing the alternative hypothesis.}
}
\description{
This function computes the Lind/Mehlum test of a U shaped relationship.
}
\details{
To test for a U shaped or inverse U shaped relationship, it is necessary to provide an interval where the shape is located.
A U shaped relationship is downward sloping at the lower bound and upward sloping at the upper bound, and vice versa for an inverted U shape.

The function assumes inputs from a model including a squared specification. The sign of the squared term is used to differentiate between U
shaped and inverted U shaped relationships.

The function provides a test of the joint hypothesis of a downward sloping relationship at \code{x.min} and an uppward sloping relationship
at \code{x.max} for U shaped relationships and vice versa for inverted U shaped relationships, as detailed in Lind and Mehlum (2010) \url{doi:10.1111/j.1468-0084.2009.00569.x}.
}
\examples{
x <- runif(100,min=-1,max=1)
xsq <- x^2
y <- x^2+rnorm(100)
mod <- lm(y~x+xsq)

utest(mod,c("x","xsq"))
utest(mod,~x+xsq,x.max=0.8)

mod.logit <- glm((y>0)~x+xsq,family="binomial")
utest(mod.logit,c("x","xsq"))
}
\references{
J. T. Lind and H. Mehlum (2010) ,  With or without U? The appropriate test for a U
shaped relationship. \emph{Oxford Bulletin of Economics and Statistics} \strong{72(1)}: 109-18,
\doi{10.1111/j.1468-0084.2009.00569.x}.
}
\seealso{
\link{uslopes}
}
