% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lancaster.R
\docType{data}
\name{lancaster_2}
\alias{lancaster_2}
\title{Secondary colours of Lancaster University, England, UK}
\format{
An object of class \code{character} of length 19.
}
\source{
Colour definitions are based on 
\href{https://www.lancaster.ac.uk/media/lancaster-university/content-assets/documents/current-staff/brand/LUBrandGuidelines-Staff-Nov-2018.pdf}{Lancaster's Primary guide (PDF)}.
}
\usage{
lancaster_2
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{lancaster_2} provides 19 secondary colours to complement the signature primary colours
of the \href{https://www.lancaster.ac.uk}{Lancaster University}, England, UK.
}
\details{
The 19 secondary colours are 
\code{"Pantone 5555"} (defined as Hex:557869),
\code{"Pantone 327"} (defined as Hex: 008375),
\code{"Pantone 3258"} (defined as Hex: 48B6ADB),
\code{"Pantone 7707"} (defined as Hex: 006382),
\code{"Pantone 2377"} (defined as Hex: 324147),

\code{"Pantone 7493"} (defined as Hex: 869978),
\code{"Pantone 346"} (defined as Hex: 75BF9A),
\code{"Pantone 5503"} (defined as Hex: 81B8BB),
\code{"Pantone 643"} (defined as Hex: C4DAE5),
\code{"Pantone 550"} (defined as Hex: 7faabe),

\code{"Pantone 459"} (defined as Hex: e3cb8b),
\code{"Pantone 7661"} (defined as Hex: 64606c),
\code{"Pantone 178"} (defined as Hex: FF7372),
\code{"Pantone 689"} (defined as Hex: 8A3E65),
\code{"Pantone 7535"} (defined as Hex: bab6a2),

\code{"Pantone 7411"} (defined as Hex: e1ab6c),
\code{"Pantone 7607"} (defined as Hex: c26763),
\code{"Pantone 1625"} (defined as Hex: F9A98E), and
\code{"Pantone 7654"} (defined as Hex: A4769A).

\code{lancaster_2} uses the HEX colour definitions.


This palette can be used in combination with the primary colour palette 
(see \code{\link{lancaster_1}}) to introduce subtlety and variety to 
certain applications. They must be used carefully to compliment and 
enrich the identity and image of \href{https://www.lancaster.ac.uk}{Lancaster University}.
}
\examples{
lancaster_2
unikn::seecol(lancaster_2, main = "Secondary colours of Lancaster University") 
# view colour palette

}
\seealso{
\code{\link{lancaster_1}} for primary colours of Lancaster University;
\code{\link[unikn]{seecol}} for viewing and comparing colour palettes;
\code{\link[unikn]{usecol}} for using colour palettes;
\code{\link[unikn]{simcol}} for finding similar colours;
\code{\link[unikn]{newpal}} for defining new colour palettes;
\code{\link[unikn]{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-27.
}
\concept{English university color palettes}
\keyword{datasets}
