% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topicmodels.R
\name{predict.LDA_VEM}
\alias{predict.LDA_VEM}
\alias{predict.LDA}
\alias{predict.LDA_Gibbs}
\title{Predict method for an object of class LDA_VEM or class LDA_Gibbs}
\usage{
\method{predict}{LDA_VEM}(
  object,
  newdata,
  type = c("topics", "terms"),
  min_posterior = -1,
  min_terms = 0,
  labels,
  ...
)

\method{predict}{LDA_Gibbs}(
  object,
  newdata,
  type = c("topics", "terms"),
  min_posterior = -1,
  min_terms = 0,
  labels,
  ...
)
}
\arguments{
\item{object}{an object of class LDA_VEM or LDA_Gibbs as returned by \code{LDA} from the topicmodels package}

\item{newdata}{a document/term matrix containing data for which to make a prediction}

\item{type}{either 'topic' or 'terms' for the topic predictions or the term posteriors}

\item{min_posterior}{numeric in 0-1 range to output only terms emitted by each 
topic which have a posterior probability equal or higher than \code{min_posterior}. 
Only used if \code{type} is 'terms'. Provide -1 if you want to keep all values.}

\item{min_terms}{integer indicating the minimum number of terms to keep in the output when \code{type} is 'terms'. Defaults to 0.}

\item{labels}{a character vector of the same length as the number of topics in the topic model. 
Indicating how to label the topics. Only valid for type = 'topic'. 
Defaults to topic_prob_001 up to topic_prob_999.}

\item{...}{further arguments passed on to topicmodels::posterior}
}
\value{
\itemize{
 \item in case of type = 'topic': a data.table with columns 
 doc_id, 
 topic (the topic number to which the document is assigned to), 
 topic_label (the topic label)
 topic_prob (the posterior probability score for that topic), 
 topic_probdiff_2nd (the probability score for that topic - the probability score for the 2nd highest topic) 
 and the probability scores for each topic as indicated by topic_labelyourownlabel
 \item n case of type = 'terms': a list of data.frames with columns term and prob, 
 giving the posterior probability that each term is emitted by the topic
}
}
\description{
Gives either the predictions to which topic a document belongs or 
the term posteriors by topic indicating which terms are emitted by each topic.\cr
If you provide in \code{newdata} a document term matrix 
for which a document does not contain any text and hence does not have any terms with nonzero entries,
the prediction will give as topic prediction NA values (see the examples).
}
\examples{
## Build document/term matrix on dutch nouns
data(brussels_reviews_anno)
data(brussels_reviews)
x <- subset(brussels_reviews_anno, language == "nl")
x <- subset(x, xpos \%in\% c("JJ"))
x <- x[, c("doc_id", "lemma")]
x <- document_term_frequencies(x)
dtm <- document_term_matrix(x)
dtm <- dtm_remove_lowfreq(dtm, minfreq = 10)
dtm <- dtm_remove_tfidf(dtm, top = 100)

\dontshow{if(require(topicmodels))\{}
## Fit a topicmodel using VEM
library(topicmodels)
mymodel <- LDA(x = dtm, k = 4, method = "VEM")

## Get topic terminology
terminology <- predict(mymodel, type = "terms", min_posterior = 0.05, min_terms = 3)
terminology

## Get scores alongside the topic model
dtm <- document_term_matrix(x, vocabulary = mymodel@terms)
scores <- predict(mymodel, newdata = dtm, type = "topics")
scores <- predict(mymodel, newdata = dtm, type = "topics", 
                  labels = c("mylabel1", "xyz", "app-location", "newlabel"))
head(scores)
table(scores$topic)
table(scores$topic_label)
table(scores$topic, exclude = c())
table(scores$topic_label, exclude = c())

## Fit a topicmodel using Gibbs
library(topicmodels)
mymodel <- LDA(x = dtm, k = 4, method = "Gibbs")
terminology <- predict(mymodel, type = "terms", min_posterior = 0.05, min_terms = 3)
scores <- predict(mymodel, type = "topics", newdata = dtm)
\dontshow{\} # End of main if statement running only if the required packages are installed}
}
\seealso{
\code{\link[topicmodels]{posterior-methods}}
}
