% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateTwomodePartition.R
\name{validateTwomodePartition}
\alias{validateTwomodePartition}
\title{Validate a two-mode clustering partition by global and per-block significance}
\usage{
validateTwomodePartition(
  myMatrix,
  rowClusters,
  colClusters,
  center = TRUE,
  perBlock = TRUE,
  monteCarlo = 0,
  fixBlockSizes = TRUE,
  storeNull = FALSE,
  seed = NULL
)
}
\arguments{
\item{myMatrix}{Numeric matrix or coercible data.frame.}

\item{rowClusters}{Integer vector of length nrow(myMatrix) with cluster labels (1..kR, arbitrary labels allowed).}

\item{colClusters}{Integer vector of length ncol(myMatrix) with cluster labels (1..kC, arbitrary labels allowed).}

\item{center}{Logical, center the matrix by its global mean before testing (default TRUE).
Centering aligns the null with zero-mean noise and generally stabilizes inference.}

\item{perBlock}{Logical, compute per-block tests (default TRUE).}

\item{monteCarlo}{Integer, number of random partitions to draw for a MC p-value (default 0 disables).}

\item{fixBlockSizes}{Logical, if TRUE keep row and column cluster sizes equal to the observed sizes
when generating random partitions (default TRUE). If FALSE, only kR and kC are fixed.}

\item{storeNull}{Logical, store the vector of null F statistics from random partitions (default FALSE).
If FALSE, only quantiles are stored.}

\item{seed}{Optional integer seed for reproducibility (default NULL).}
}
\value{
A list of class "twomodeValidation" with elements:
\itemize{
\item \code{nR}, \code{nC}, \code{kR}, \code{kC}
\item \code{dfModel}, \code{dfResid}
\item \code{ssTot}, \code{ssFit}, \code{sse}, \code{sigma2Hat}, \code{r2}
\item \code{fStat}, \code{pValue} (global F test)
\item \code{perBlock} (data.frame with per-block stats) if \code{perBlock=TRUE}
\item \code{mc} (list with \code{nSim}, \code{pMonteCarlo}, \code{fNull} or \code{fNullQuantiles}) if \code{monteCarlo>0}
}
}
\description{
Given a numeric matrix and a full two-mode partition (exclusive row and column clusters),
this function tests whether the fitted block-means model explains more structure
than expected under a no-structure null. The global test uses an F-statistic based
on SS_fit and SSE derived from your fitness definition. Optionally, it also reports
per-block chi-square tests and a fast Monte Carlo p-value using random partitions
(no GA reruns).
}
\examples{
data("twomodeToy")
myMatrix_s <- scale(twomodeToy)

#Run the GA-based two-mode clustering
result <- twomodeClusteringGA(
  myMatrix = myMatrix_s,
  nRowClusters = 2,
  nColClusters = 3,
  seeds = 1,
  maxiter = 200,
  popSize = 30,
  elitism = 1,
  validate = FALSE,
  verbose = TRUE
)

result$validation <- validateTwomodePartition(myMatrix_s, 
                                rowClusters=result$rowClusters, 
                                colClusters=result$colClusters)

#Inspect the result
print(result)
summary(result)
myTwomodeResult <- as.data.frame(result)
head(myTwomodeResult)

#Plot the clustered heatmap
plotTwomodeClustering(
  myMatrix = myMatrix_s,
  result   = result,
  title    = "Two-mode clustering Toy example",
  fixAspect = FALSE
)
}
