% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LmME.R
\name{coef.LmME}
\alias{coef.LmME}
\title{Extract the coefficients of an \code{LmME} model}
\usage{
\method{coef}{LmME}(object, as.lm = FALSE, fixed = TRUE, ...)
}
\arguments{
\item{object}{An \code{LmME} object.}

\item{as.lm}{If \code{TRUE}, return the transformed coefficients as in a
\code{lmerMod} object.}

\item{fixed}{If \code{TRUE}, also include the fixed parameters.}

\item{...}{Optional arguments passed to \code{\link{coef.tramME}}.}
}
\value{
A numeric vector of the transformed coefficients.
}
\description{
Extracts the fixed effects coefficents (default behavior), the baseline
parameters or all (baseline, fixed and random) coefficients of the model.
}
\details{
See also the documentation of \code{\link{coef.tramME}}.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
coef(fit, as.lm = TRUE)
}
