% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layers_text.R
\name{tm_text}
\alias{tm_text}
\alias{tm_labels}
\alias{tm_labels_highlighted}
\alias{opt_tm_text}
\alias{opt_tm_labels}
\title{Map layer: text}
\usage{
tm_text(
  text = tm_const(),
  text.scale = tm_scale(),
  text.legend = tm_legend(),
  text.chart = tm_chart_none(),
  text.free = NA,
  size = tm_const(),
  size.scale = tm_scale(),
  size.legend = tm_legend(),
  size.chart = tm_chart_none(),
  size.free = NA,
  col = tm_const(),
  col.scale = tm_scale(),
  col.legend = tm_legend(),
  col.chart = tm_chart_none(),
  col.free = NA,
  col_alpha = tm_const(),
  col_alpha.scale = tm_scale(),
  col_alpha.legend = tm_legend(),
  col_alpha.chart = tm_chart_none(),
  col_alpha.free = NA,
  fontface = tm_const(),
  fontface.scale = tm_scale(),
  fontface.legend = tm_legend(),
  fontface.chart = tm_chart_none(),
  fontface.free = NA,
  fontfamily = NA,
  bgcol = tm_const(),
  bgcol.scale = tm_scale(),
  bgcol.legend = tm_legend(),
  bgcol.chart = tm_chart_none(),
  bgcol.free = NA,
  bgcol_alpha = tm_const(),
  bgcol_alpha.scale = tm_scale(),
  bgcol_alpha.legend = tm_legend(),
  bgcol_alpha.chart = tm_chart_none(),
  bgcol_alpha.free = NA,
  xmod = 0,
  xmod.scale = tm_scale(),
  xmod.legend = tm_legend_hide(),
  xmod.chart = tm_chart_none(),
  xmod.free = NA,
  ymod = 0,
  ymod.scale = tm_scale(),
  ymod.legend = tm_legend_hide(),
  ymod.chart = tm_chart_none(),
  ymod.free = NA,
  angle = 0,
  angle.scale = tm_scale(),
  angle.legend = tm_legend_hide(),
  angle.chart = tm_chart_none(),
  angle.free = NA,
  plot.order = tm_plot_order("size", reverse = FALSE),
  zindex = NA,
  group = NA,
  group.control = "check",
  options = opt_tm_text(),
  ...
)

tm_labels(
  text = tm_const(),
  text.scale = tm_scale(),
  text.legend = tm_legend(),
  text.chart = tm_chart_none(),
  text.free = NA,
  size = tm_const(),
  size.scale = tm_scale(),
  size.legend = tm_legend(),
  size.chart = tm_chart_none(),
  size.free = NA,
  col = tm_const(),
  col.scale = tm_scale(),
  col.legend = tm_legend(),
  col.chart = tm_chart_none(),
  col.free = NA,
  col_alpha = tm_const(),
  col_alpha.scale = tm_scale(),
  col_alpha.legend = tm_legend(),
  col_alpha.chart = tm_chart_none(),
  col_alpha.free = NA,
  fontface = tm_const(),
  fontface.scale = tm_scale(),
  fontface.legend = tm_legend(),
  fontface.chart = tm_chart_none(),
  fontface.free = NA,
  fontfamily = "",
  bgcol = tm_const(),
  bgcol.scale = tm_scale(),
  bgcol.legend = tm_legend(),
  bgcol.chart = tm_chart_none(),
  bgcol.free = NA,
  bgcol_alpha = tm_const(),
  bgcol_alpha.scale = tm_scale(),
  bgcol_alpha.legend = tm_legend(),
  bgcol_alpha.chart = tm_chart_none(),
  bgcol_alpha.free = NA,
  xmod = 0,
  xmod.scale = tm_scale(),
  xmod.legend = tm_legend_hide(),
  xmod.chart = tm_chart_none(),
  xmod.free = NA,
  ymod = 0,
  ymod.scale = tm_scale(),
  ymod.legend = tm_legend_hide(),
  ymod.chart = tm_chart_none(),
  ymod.free = NA,
  angle = 0,
  angle.scale = tm_scale(),
  angle.legend = tm_legend_hide(),
  angle.chart = tm_chart_none(),
  angle.free = NA,
  plot.order = tm_plot_order("AREA", reverse = FALSE, na.order = "bottom"),
  zindex = NA,
  group = NA,
  group.control = "check",
  options = opt_tm_labels(),
  ...
)

tm_labels_highlighted(
  text = tm_const(),
  text.scale = tm_scale(),
  text.legend = tm_legend(),
  text.chart = tm_chart_none(),
  text.free = NA,
  size = tm_const(),
  size.scale = tm_scale(),
  size.legend = tm_legend(),
  size.chart = tm_chart_none(),
  size.free = NA,
  col = tm_const(),
  col.scale = tm_scale(),
  col.legend = tm_legend(),
  col.chart = tm_chart_none(),
  col.free = NA,
  col_alpha = tm_const(),
  col_alpha.scale = tm_scale(),
  col_alpha.legend = tm_legend(),
  col_alpha.chart = tm_chart_none(),
  col_alpha.free = NA,
  fontface = tm_const(),
  fontface.scale = tm_scale(),
  fontface.legend = tm_legend(),
  fontface.chart = tm_chart_none(),
  fontface.free = NA,
  fontfamily = "",
  bgcol = tm_const(),
  bgcol.scale = tm_scale(),
  bgcol.legend = tm_legend(),
  bgcol.chart = tm_chart_none(),
  bgcol.free = NA,
  bgcol_alpha = tm_const(),
  bgcol_alpha.scale = tm_scale(),
  bgcol_alpha.legend = tm_legend(),
  bgcol_alpha.chart = tm_chart_none(),
  bgcol_alpha.free = NA,
  xmod = 0,
  xmod.scale = tm_scale(),
  xmod.legend = tm_legend_hide(),
  xmod.chart = tm_chart_none(),
  xmod.free = NA,
  ymod = 0,
  ymod.scale = tm_scale(),
  ymod.legend = tm_legend_hide(),
  ymod.chart = tm_chart_none(),
  ymod.free = NA,
  angle = 0,
  angle.scale = tm_scale(),
  angle.legend = tm_legend_hide(),
  angle.chart = tm_chart_none(),
  angle.free = NA,
  plot.order = tm_plot_order("AREA", reverse = FALSE, na.order = "bottom"),
  zindex = NA,
  group = NA,
  group.control = "check",
  options = opt_tm_labels(),
  ...
)

opt_tm_text(
  points_only = "ifany",
  point_per = "feature",
  on_surface = FALSE,
  shadow = FALSE,
  shadow.offset.x = 0.1,
  shadow.offset.y = 0.1,
  just = "center",
  along_lines = FALSE,
  bg.padding = 0.4,
  clustering = FALSE,
  point.label = FALSE,
  point.label.gap = 0,
  point.label.method = "SANN",
  remove_overlap = FALSE
)

opt_tm_labels(
  points_only = "ifany",
  point_per = "feature",
  on_surface = FALSE,
  shadow = FALSE,
  shadow.offset.x = 0.1,
  shadow.offset.y = 0.1,
  just = "center",
  along_lines = TRUE,
  bg.padding = 0.4,
  clustering = FALSE,
  point.label = NA,
  point.label.gap = 0.4,
  point.label.method = "SANN",
  remove_overlap = FALSE
)
}
\arguments{
\item{text, text.scale, text.legend, text.chart, text.free}{Visual variable that determines the text. See details.}

\item{size, size.scale, size.legend, size.chart, size.free}{Visual variable that determines the size. See details.}

\item{col, col.scale, col.legend, col.chart, col.free}{Visual variable that determines the color. See details.}

\item{col_alpha, col_alpha.scale, col_alpha.legend, col_alpha.chart, col_alpha.free}{Visual variable that determines the color transparency. See details.}

\item{fontface, fontface.scale, fontface.legend, fontface.chart, fontface.free}{Visual variable that determines the font face. See details.}

\item{fontfamily}{The font family. See \link[grid:gpar]{gpar()} for details.}

\item{bgcol, bgcol.scale, bgcol.legend, bgcol.chart, bgcol.free}{Visual variable that determines
the background color. See Details.}

\item{bgcol_alpha, bgcol_alpha.scale, bgcol_alpha.legend, bgcol_alpha.chart, bgcol_alpha.free}{Visual variable that determines
the background color transparency. See Details.}

\item{xmod, xmod.scale, xmod.legend, xmod.chart, xmod.free}{Transformation variable that determines the x offset. See details.}

\item{ymod, ymod.scale, ymod.legend, ymod.chart, ymod.free}{Transformation variable that determines the y offset. See details.
the text. See details.}

\item{angle, angle.scale, angle.legend, angle.chart, angle.free}{Rotation angle}

\item{plot.order}{Specification in which order the spatial features are drawn.
See \code{\link[=tm_plot_order]{tm_plot_order()}} for details.}

\item{zindex}{Map layers are drawn on top of each other. The \code{zindex} numbers
(one for each map layer) determines the stacking order.
By default the map layers are drawn in the order they are called.}

\item{group}{Name of the group to which this layer belongs. This is only
relevant in view mode, where layer groups can be switched (see \code{group.control})}

\item{group.control}{In view mode, the group control determines how layer groups
can be switched on and off. Options: \code{"radio"} for radio buttons
(meaning only one group can be shown), \code{"check"} for check boxes
(so multiple groups can be shown), and \code{"none"} for no control
(the group cannot be (de)selected).}

\item{options}{options passed on to the corresponding \verb{opt_<layer_function>} function}

\item{...}{to catch deprecated arguments from version < 4.0}

\item{points_only}{should only point geometries of the shape object (defined in \code{\link[=tm_shape]{tm_shape()}}) be plotted? By default \code{"ifany"}, which means \code{TRUE} in case a geometry collection is specified.}

\item{point_per}{specification of how spatial points are mapped when the geometry is a multi line or a multi polygon. One of \code{"feature"}, \code{"segment"} or \code{"largest"}. The first generates a spatial point for every feature, the second for every segment (i.e. subfeature), the third only for the largest segment (subfeature). Note that the last two options can be significant slower.}

\item{on_surface}{In case of polygons, centroids are computed. Should the points be on the surface? If \code{TRUE}, which is slower than the default \code{FALSE}, centroids outside the surface are replaced with points computed with \code{\link[sf:geos_unary]{sf::st_point_on_surface()}}.}

\item{shadow}{Shadow behind the text. Logical or color.}

\item{shadow.offset.x, shadow.offset.y}{Shadow offset in line heights}

\item{just}{justification of the text relative to the point coordinates. Either one of the following values: \code{"left"} , \code{"right"}, \code{"center"}, \code{"bottom"}, and \code{"top"}, or a vector of two values where first value specifies horizontal and the second value vertical justification. Besides the mentioned values, also numeric values between 0 and 1 can be used. 0 means left justification for the first value and bottom justification for the second value. Note that in view mode, only one value is used.}

\item{along_lines}{logical that determines whether labels are rotated along the spatial lines. Only applicable if a spatial lines shape is used.}

\item{bg.padding}{The padding of the background in terms of line heights.}

\item{clustering}{value that determines whether the text labels are clustered in \code{"view"} mode. One of: \code{TRUE}, \code{FALSE}, or the output of \code{\link[leaflet:markerClusterOptions]{markerClusterOptions}}.}

\item{point.label}{logical that determines whether the labels are placed automatically. By default \code{FALSE} for \code{tm_text}, and \code{TRUE} for \code{tm_labels} if the number of labels is less than 500 (otherwise it will be too slow).}

\item{point.label.gap}{numeric that determines the gap between the point and label}

\item{point.label.method}{the optimization method, either \code{"SANN"} for simulated annealing (the default) or \code{"GA"} for a genetic algorithm.}

\item{remove_overlap}{logical that determines whether the overlapping labels are removed}
}
\description{
Map layer that draws symbols Supported visual variables are: \code{text}
(the text itself) \code{col} (color), \code{size} (font size), and \code{fontface} (font face).
}
\details{
The visual variable arguments (e.g. \code{col}) can be specified with either a data
variable name (e.g., a spatial vector attribute or a raster layer of the object
specified in \code{\link[=tm_shape]{tm_shape()}}), or with a visual value (for \code{col}, a color is expected).
See \href{https://r-tmap.github.io/tmap/articles/basics_vv}{vignette about visual variables}.

Multiple values can be specified: in that case facets are created.
These facets can be combined with other faceting data variables, specified with \code{\link[=tm_facets]{tm_facets()}}.
See \href{https://r-tmap.github.io/tmap/articles/basics_facets}{vignette about facets}.
\itemize{
\item The \verb{*.scale} arguments determine the used scale to map the data values to
visual variable values. These can be specified with one of the available
\verb{tm_scale_*()} functions. The default is specified by the tmap option (\code{\link[=tm_options]{tm_options()}}) \code{scales.var}.
See \href{https://r-tmap.github.io/tmap/articles/basics_scales}{vignette about scales}.
\item The \verb{*.legend} arguments determine the used legend, specified with \code{\link[=tm_legend]{tm_legend()}}.
The default legend and its settings are determined by the tmap options (\code{\link[=tm_options]{tm_options()}}) \code{legend.} .
See \href{https://r-tmap.github.io/tmap/articles/basics_legends}{vignette about legends}.
\item The \verb{*.chart} arguments specify additional charts, specified with \code{tm_chart_}, e.g. \code{\link[=tm_chart_histogram]{tm_chart_histogram()}}.
See \href{https://r-tmap.github.io/tmap/articles/basics_charts}{vignette about charts}.
\item The \verb{*.free} arguments determine whether scales are applied freely across facets, or shared.
A logical value is required. They can also be specified with a vector of three
logical values; these determine whether scales are applied freely per facet dimension.
This is only useful when facets are applied (see \code{\link[=tm_facets]{tm_facets()}}).
There are maximally three facet dimensions: rows, columns, and pages. This only
applies for a facet grid (\code{\link[=tm_facets_grid]{tm_facets_grid()}}). For instance, \code{col.free = c(TRUE, FALSE, FALSE)}
means that for the visual variable \code{col}, each row of facets will have its own
scale, and therefore its own legend. For facet wraps and stacks
(\code{\link[=tm_facets_wrap]{tm_facets_wrap()}} and \code{\link[=tm_facets_stack]{tm_facets_stack()}}) there is only one facet dimension,
so the \verb{*.free} argument requires only one logical value.
}
}
\examples{
tm_shape(World, bbox = World) +
	tm_text("name", size="pop_est", col="continent",
			col.scale = tm_scale_categorical(values = "seaborn.dark"),
			col.legend = tm_legend_hide(),
			size.scale = tm_scale_continuous(values.scale = 4),
			size.legend = tm_legend_hide())

metro$upside_down = ifelse(sf::st_coordinates(metro)[,2] < 0, 180, 0)
tm_shape(metro) +
	tm_text(text = "name", size = "pop2020",
			angle = "upside_down", size.legend = tm_legend_hide(),
			col = "upside_down",
			col.scale = tm_scale_categorical(values = c("#9900BB", "#228822")),
			col.legend = tm_legend_hide()) +
	tm_title_out("Which Hemisphere?", position = tm_pos_out("center", "top", pos.v = "bottom"))

}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/examples_terrain}{Terrain map example}

\href{https://r-tmap.github.io/tmap/articles/examples_topo_Africa}{Topographic map}
}
