% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layout.R
\name{tm_style}
\alias{tm_style}
\alias{tm_layout}
\title{Layout options}
\usage{
tm_style(style, ...)

tm_layout(
  scale,
  asp,
  legend.only,
  bg,
  bg.color,
  outer.bg,
  outer.bg.color,
  frame,
  frame.color,
  frame.alpha,
  frame.lwd,
  frame.r,
  frame.double_line,
  outer.margins,
  inner.margins,
  inner.margins.extra,
  meta.margins,
  meta.auto_margins,
  between_margin,
  text.fontfamily,
  text.fontface,
  r,
  attr.color,
  panel.margin,
  panel.type,
  panel.wrap.pos,
  panel.xtab.pos,
  color.sepia_intensity,
  color.saturation,
  color_vision_deficiency_sim,
  panel.show,
  panel.labels,
  panel.label.size,
  panel.label.color,
  panel.label.fontface,
  panel.label.fontfamily,
  panel.label.alpha,
  panel.label.bg,
  panel.label.bg.color,
  panel.label.bg.alpha,
  panel.label.frame,
  panel.label.frame.color,
  panel.label.frame.alpha,
  panel.label.frame.lwd,
  panel.label.frame.r,
  panel.label.height,
  panel.label.rot,
  earth_boundary,
  earth_boundary.color,
  earth_boundary.lwd,
  earth_datum,
  space,
  space.color,
  ...
)
}
\arguments{
\item{style}{name of the style}

\item{...}{List of tmap options to be set, or option names (characters) to be returned (see details)}

\item{scale}{Overall scale of the map}

\item{asp}{Aspect ratio of each map. When \code{asp} is set to \code{NA} (default) the aspect ratio will be adjusted to the used shapes. When set to 0 the aspect ratio is
adjusted to the size of the device divided by the number of columns and rows.}

\item{legend.only}{Should only legends be printed (so without map)?}

\item{bg}{Draw map background?}

\item{bg.color}{Background color of the map.}

\item{outer.bg}{Draw map background (outside the frame)?}

\item{outer.bg.color}{Background color of map outside the frame.}

\item{frame}{Draw map frame?}

\item{frame.color}{The color of the frame.}

\item{frame.alpha}{The alpha transparency of the frame.}

\item{frame.lwd}{The line width of the frame. See \code{graphics::par}, option 'lwd'.}

\item{frame.r}{The r (radius) of the frame.}

\item{frame.double_line}{The double line of the frame. \code{TRUE} or \code{FALSE}.}

\item{outer.margins}{The margins of the outer space (outside the frame. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{inner.margins}{The margins of the inner space (inside the frame). A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{inner.margins.extra}{The extra arguments of the margins of the inner space (inside the frame). A list of arguments.}

\item{meta.margins}{The margins of the meta. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{meta.auto_margins}{The auto_margins of the meta.}

\item{between_margin}{Margin between the map.}

\item{text.fontfamily}{The font family of the text. See \code{graphics::par}, option 'family'.}

\item{text.fontface}{The font face of the text. See \code{graphics::par}, option 'font'.}

\item{r}{The r (radius) (overall).}

\item{attr.color}{The color of the attr.}

\item{panel.margin}{The margin of the panel.}

\item{panel.type}{The type of the panel.}

\item{panel.wrap.pos}{The panel positions for wrapped facets created with \code{\link[=tm_facets_grid]{tm_facets_grid()}}. One of \code{"left"}, \code{"right"}, \code{"top"} (default) or \code{"bottom"}.}

\item{panel.xtab.pos}{The panel positions for grid facets created with \code{\link[=tm_facets_grid]{tm_facets_grid()}}. Vector of two, where the first determines the locations of row panels (\code{"left"} or \code{"right"}) and the second the location of column panels ( \code{"top"} or `"bottom")}

\item{color.sepia_intensity}{The sepia_intensity of the color.}

\item{color.saturation}{The saturation of the color.}

\item{color_vision_deficiency_sim}{Color vision deficiency simulation. Either \code{"protan"}, \code{"deutan"}, or \code{"tritan"}.}

\item{panel.show}{The visibility of the panel. \code{TRUE} or \code{FALSE}.}

\item{panel.labels}{The labels of the panel.}

\item{panel.label.size}{The size of the label of the panel.}

\item{panel.label.color}{The color of the label of the panel.}

\item{panel.label.fontface}{The font face of the label of the panel. See \code{graphics::par}, option 'font'.}

\item{panel.label.fontfamily}{The font family of the label of the panel. See \code{graphics::par}, option 'family'.}

\item{panel.label.alpha}{The alpha transparency of the label of the panel.}

\item{panel.label.bg}{The bg of the label of the panel.}

\item{panel.label.bg.color}{The color of the bg of the label of the panel.}

\item{panel.label.bg.alpha}{The alpha transparency of the bg of the label of the panel.}

\item{panel.label.frame}{The frame of the label of the panel.}

\item{panel.label.frame.color}{The color of the frame of the label of the panel.}

\item{panel.label.frame.alpha}{The alpha transparency of the frame of the label of the panel.}

\item{panel.label.frame.lwd}{The line width of the frame of the label of the panel. See \code{graphics::par}, option 'lwd'.}

\item{panel.label.frame.r}{The r (radius) of the frame of the label of the panel.}

\item{panel.label.height}{The height of the label of the panel.}

\item{panel.label.rot}{Rotation angles of the panel labels. Vector of four values that determine the panel label rotation when they are placed left, top, right, and bottom. The default angles are 90, 0, 270 and 0 respectively. Note that the second value is the most common, since labels are by default shown on top (see \code{panel.wrap.pos}). In cross-table facets created with \code{tm_facets_grid()}, the first two values are used by default (see \code{panel.xtab.pos}).}

\item{earth_boundary}{The earth boundary}

\item{earth_boundary.color}{The color of the earth_boundary.}

\item{earth_boundary.lwd}{The line width of the earth_boundary. See \code{graphics::par}, option 'lwd'.}

\item{earth_datum}{Earth datum}

\item{space}{Should the space be drawn? Only applicable is earth_boundary is enabled.}

\item{space.color}{The color of the space.}
}
\description{
Specify the layout of the maps. \code{\link[=tm_layout]{tm_layout()}} is identical as \code{\link[=tm_options]{tm_options()}} but only contain the tmap options that are directly related to the layout. \code{\link[=tm_style]{tm_style()}} sets the style for the map. A style is a specified set of options (that can be changed afterwards with \code{\link[=tm_layout]{tm_layout()}}). These functions are used within a plot a plot call (stacked with the \code{+} operator). Their counterparts \code{\link[=tmap_options]{tmap_options()}} and \code{\link[=tmap_style]{tmap_style()}} can be used to set the (layout) options globally.
}
\examples{
tm_shape(World) +
  tm_polygons() +
tm_layout(
  bg.color = "steelblue",
  outer.bg.color = "gold",
  frame.lwd = 3,
  inner.margins = 0)

tm_shape(World) +
  tm_polygons(fill = "HPI") +
tm_style("classic")

tm_shape(World) +
	tm_polygons(fill = "HPI") +
	tm_style("cobalt")
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_layout}{Vignette about layout}, \href{https://r-tmap.github.io/tmap/articles/adv_margins}{vignette about margins and aspect ratio} and \href{https://r-tmap.github.io/tmap/articles/adv_options}{vignette about options}
}
