% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/playlists.R
\name{get_user_playlists}
\alias{get_user_playlists}
\title{Get a list of the playlists owned or followed by a Spotify user.}
\usage{
get_user_playlists(
  user_id,
  limit = 20,
  offset = 0,
  authorization = get_spotify_authorization_code(),
  include_meta_info = FALSE
)
}
\arguments{
\item{user_id}{Required. The user's \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify user ID}.}

\item{limit}{Optional. \cr
Maximum number of playlists to return. \cr
Default: 20 \cr
Minimum: 1 \cr
Maximum: 50 \cr}

\item{offset}{Optional. \cr
The index of the first playlist to return. \cr
Default: 0 (the first object). Maximum offset: 100,000. Use with \code{limit} to get the next set of playlists.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_authorization_code()}. The access token must have been issued on behalf of the current user. \cr
Private playlists are only retrievable for the current user and requires the \code{playlist-read-private} \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{scope} to have been authorized by the user. Note that this scope alone will not return collaborative playlists, even though they are always private. \cr
Collaborative playlists are only retrievable for the current user and requires the \code{playlist-read-collaborative} \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{scope} to have been authorized by the user.}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result, with meta information such as \code{"total"}, and \code{"limit"}. Defaults to \code{FALSE}.}
}
\value{
Returns a data frame of results containing user playlist information. See the official \href{https://developer.spotify.com/documentation/web-api/reference/playlists/get-list-users-playlists/}{Spotify Web API documentation} for more information.
}
\description{
Get a list of the playlists owned or followed by a Spotify user.
}
