% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-filter_period.R
\name{filter_period}
\alias{filter_period}
\title{Apply filtering expressions inside periods (windows)}
\usage{
filter_period(.data, ..., .date_var, .period = "1 day")
}
\arguments{
\item{.data}{A \code{tbl} object or \code{data.frame}}

\item{...}{Filtering expression. Expressions that return a logical value, and are defined in
terms of the variables in .data. If multiple expressions are included, they are combined with
the & operator. Only rows for which all conditions evaluate to TRUE are kept.}

\item{.date_var}{A column containing date or date-time values.
If missing, attempts to auto-detect date column.}

\item{.period}{A period to filter within.
Time units are grouped using \code{lubridate::floor_date()} or \code{lubridate::ceiling_date()}.

The value can be:
\itemize{
\item \code{second}
\item \code{minute}
\item \code{hour}
\item \code{day}
\item \code{week}
\item \code{month}
\item \code{bimonth}
\item \code{quarter}
\item \code{season}
\item \code{halfyear}
\item \code{year}
}

Arbitrary unique English abbreviations as in the \code{lubridate::period()} constructor are allowed:
\itemize{
\item \code{"1 year"}
\item \code{"2 months"}
\item \code{"30 seconds"}
}}
}
\value{
A \code{tibble} or \code{data.frame}
}
\description{
Applies a dplyr \emph{\strong{filtering expression inside a time-based period (window).}}
See \code{\link[=filter_by_time]{filter_by_time()}} for filtering continuous ranges defined by start/end dates.
\code{filter_period()} enables filtering expressions like:
\itemize{
\item Filtering to the maximum value each month.
\item Filtering the first date each month.
\item Filtering all rows with value greater than a monthly average
}
}
\examples{
# Libraries
library(dplyr)

# Max value in each month
m4_daily \%>\%
    group_by(id) \%>\%
    filter_period(.period = "1 month", value == max(value))

# First date each month
m4_daily \%>\%
    group_by(id) \%>\%
    filter_period(.period = "1 month", date == first(date))

# All observations that are greater than a monthly average
m4_daily \%>\%
    group_by(id) \%>\%
    filter_period(.period = "1 month", value > mean(value))

}
\seealso{
Time-Based dplyr functions:
\itemize{
\item \code{\link[=summarise_by_time]{summarise_by_time()}} - Easily summarise using a date column.
\item \code{\link[=mutate_by_time]{mutate_by_time()}} - Simplifies applying mutations by time windows.
\item \code{\link[=pad_by_time]{pad_by_time()}} - Insert time series rows with regularly spaced timestamps
\item \code{\link[=filter_by_time]{filter_by_time()}} - Quickly filter using date ranges.
\item \code{\link[=filter_period]{filter_period()}} - Apply filtering expressions inside periods (windows)
\item \code{\link[=slice_period]{slice_period()}} - Apply slice inside periods (windows)
\item \code{\link[=condense_period]{condense_period()}} - Convert to a different periodicity
\item \code{\link[=between_time]{between_time()}} - Range detection for date or date-time sequences.
\item \code{\link[=slidify]{slidify()}} - Turn any function into a sliding (rolling) function
}
}
