% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_corrosion.R
\name{calculate_corrosion}
\alias{calculate_corrosion}
\alias{calculate_corrosion_df}
\title{Calculate six corrosion and scaling indices (AI, RI, LSI, LI, CSMR, CCPP)}
\source{
AWWA (1977)

Crittenden et al. (2012)

Langelier (1936)

Larson and Skold (1958)

Merrill and Sanks (1977a)

Merrill and Sanks (1977b)

Merrill and Sanks (1978)

Nguyen et al. (2011)

Plummer and Busenberg (1982)

Ryznar (1944)

Schock (1984)

Trussell (1998)

U.S. EPA (1980)

See reference list at \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
calculate_corrosion(
  water,
  index = c("aggressive", "ryznar", "langelier", "ccpp", "larsonskold", "csmr"),
  form = "calcite"
)

calculate_corrosion_df(
  df,
  input_water = "defined",
  water_prefix = TRUE,
  index = c("aggressive", "ryznar", "langelier", "ccpp", "larsonskold", "csmr"),
  form = "calcite"
)
}
\arguments{
\item{water}{Source water of class "water" created by \link{define_water}}

\item{index}{The indices to be calculated.
Default calculates all six indices: "aggressive", "ryznar", "langelier", "ccpp", "larsonskold", "csmr"
CCPP may not be able to be calculated sometimes, so it may be advantageous to leave this out of the function to avoid errors}

\item{form}{Form of calcium carbonate mineral to use for modelling solubility: "calcite" (default), "aragonite", or "vaterite"}

\item{df}{a data frame containing a water class column, created using \link{define_water}}

\item{input_water}{name of the column of water class data to be used as the input. Default is "defined".}

\item{water_prefix}{append water name to beginning of output columns. Defaults to TRUE}
}
\value{
\code{calculate_corrosion} returns a data frame with corrosion and scaling indices as individual columns.

\code{calculate_corrosion_df} returns the a data frame containing specified corrosion and scaling indices as columns.
}
\description{
This function takes an object created by \link{define_water} and calculates
corrosion and scaling indices. For a single water, use \code{calculate_corrosion}; to apply the calculations to a
dataframe, use \code{calculate_corrosion_df}.
}
\details{
Aggressiveness Index (AI), unitless - the corrosive tendency of water and its effect on asbestos cement pipe.

Ryznar Index (RI), unitless - a measure of scaling potential.

Langelier Saturation Index (LSI), unitless - describes the potential for calcium carbonate scale formation.
Equations use empirical calcium carbonate solubilities from Plummer and Busenberg (1982) and Crittenden et al. (2012)
rather than calculated from the concentrations of calcium and carbonate in the water.

Larson-skold Index (LI), unitless - describes the corrosivity towards mild steel.

Chloride-to-sulfate mass ratio (CSMR), mg Cl/mg SO4 - indicator of galvanic corrosion for lead solder pipe joints.

Calcium carbonate precipitation potential (CCPP), mg/L as CaCO3 - a prediction of the mass of calcium carbonate that will precipitate at equilibrium.
A positive CCPP value indicates the amount of CaCO3 (mg/L as CaCO3) that will precipitate.
A negative CCPP indicates how much CaCO3 can be dissolved in the water.
}
\examples{
water <- define_water(
  ph = 8, temp = 25, alk = 200, tot_hard = 200,
  tds = 576, cl = 150, so4 = 200
)
corrosion_indices <- calculate_corrosion(water)

water <- define_water(ph = 8, temp = 25, alk = 100, tot_hard = 50, tds = 200)
corrosion_indices <- calculate_corrosion(water, index = c("aggressive", "ccpp"))


example_df <- water_df \%>\%
  define_water_df() \%>\%
  calculate_corrosion_df(index = c("aggressive", "ccpp"))

}
