% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal_test.R
\name{equal_test}
\alias{equal_test}
\title{Test for Equality of Variances}
\usage{
equal_test(data, var, group, center = "median")
}
\arguments{
\item{data}{A data frame containing the variables to be tested.}

\item{var}{A character string specifying the numeric variable in \code{data} to test.}

\item{group}{A character string specifying the grouping variable in \code{data}.}

\item{center}{A character string specifying the \code{center} to use in Levene's test. Default is \code{'median'}, which is more robust than the mean.}
}
\value{
Logical value:
\itemize{
\item \code{TRUE}: Variances are equal, p-value more than 0.05
\item \code{FALSE}: Variances are unequal or an error occurred during testing
}
}
\description{
Performs Levene's test to assess equality of variances between groups.
}
\section{Methodology for Equality of Variances}{

Levene's test is the default method adopted in SPSS, the original Levene's test select center = mean, but here select center = median for a more robust test
}

\examples{
equal_test(iris, "Sepal.Length", "Species")

}
