% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.R
\name{prune_dag}
\alias{prune_dag}
\title{Prune DAG Based on Adjustment Sets}
\usage{
prune_dag(
  x,
  exposure = NULL,
  outcome = NULL,
  which_set = c("first", "sample", "all"),
  ...
)
}
\arguments{
\item{x}{An input graph of class \code{dagitty}.}

\item{exposure}{Atomic character, name of the exposure variable.}

\item{outcome}{Atomic character, name of the outcome variable.}

\item{which_set}{Atomic character, indicating which set of covariates to
select in case there are multiple. Valid choices are in
\code{c("first", "sample", "all")}, see Value.}

\item{...}{Other arguments passed to \link[dagitty]{adjustmentSets}}
}
\value{
If \code{which_set = "all"}, returns a list of \code{data.frames} to allow for
sensitivity analyses. Otherwise, returns a \code{data.frame}.
}
\description{
Wraps \link[dagitty]{adjustmentSets} to construct a pruned DAG
which only includes covariates that (asymptotically) allow unbiased
estimation of the causal effects of interest.
}
\examples{
dag <- dagitty::dagitty('dag {x -> y}')
prune_dag(dag, exposure = "x", outcome = "y")
}
\seealso{
\code{\link[dagitty]{adjustmentSets}}
}
