% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_W_c_volB.R
\name{compute_W_c_volB}
\alias{compute_W_c_volB}
\title{Determine the function W, radius c and volume of B from Metodiev et al.(2025)}
\usage{
compute_W_c_volB(
  params,
  limit,
  lps,
  logpost,
  sims,
  iters,
  ellipse,
  type = "simple",
  lps_unif = NULL,
  max_iters = Inf
)
}
\arguments{
\item{params}{sample from the posterior (as a matrix)}

\item{limit}{the limit placed on the lps}

\item{lps}{values of the unnormalized log posterior density}

\item{logpost}{function used to compute the lps}

\item{sims}{n_simul x G x (u+1) array of parameters sampled from
the posterior, where
  n_simul is the number of simulations from the posterior,
  G       is the number of components,
  u       is the number of mixture component parameters
          (parameter u+1 is the mixture weight)}

\item{iters}{half the number of simulations from the posterior}

\item{ellipse}{the ellipsoid E from Metodiev et al. (2025)}

\item{type}{THAMES variant ("simple", "permutations", or "standard")}

\item{lps_unif}{values of the unnormalized log posterior density,
evaluated on a uniform sample on the posterior ellipsoid}

\item{max_iters}{maximum number of shrinkage iterations}
}
\value{
a named list with the following elements:
         perms:      number of permutations that were evaluated
         graph:      the overlap graph for G
         c_opt:      the radius of the ellipsoid in Metodiev et al. (2025)
         scaling:    list of fit determined via QDA (means and covariances)
         log_cor:    used to compute the volume of B in Metodiev et al.(2025)
         param_test: Monte Carlo sample used to compute the volume of B
         co:         the criterion of overlap for G
         ellipse:    the ellipsoid, potentially shifted to the sample mode
}
\description{
Determine the function W, radius c and volume of B from Metodiev et al.(2025)
}
\references{
Martin Metodiev, Nicholas J. Irons, Marie Perrot-Dockès,
Pierre Latouche, Adrian E. Raftery. "Easily Computed Marginal Likelihoods
for Multivariate Mixture Models Using the THAMES Estimator."
arXiv preprint arXiv:2504.21812.
}
\keyword{internal}
