% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts-functions.R
\name{sts_build_factored_variational_loss}
\alias{sts_build_factored_variational_loss}
\title{Build a loss function for variational inference in STS models.}
\usage{
sts_build_factored_variational_loss(
  observed_time_series,
  model,
  init_batch_shape = list(),
  seed = NULL,
  name = NULL
)
}
\arguments{
\item{observed_time_series}{\code{float} \code{tensor} of shape
\verb{concat([sample_shape, model.batch_shape, [num_timesteps, 1]])} where
\code{sample_shape} corresponds to i.i.d. observations, and the trailing \verb{[1]}
dimension may (optionally) be omitted if \code{num_timesteps > 1}. May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.}

\item{model}{An instance of \code{StructuralTimeSeries} representing a
time-series model. This represents a joint distribution over
time-series and their parameters with batch shape \verb{[b1, ..., bN]}.}

\item{init_batch_shape}{Batch shape (\code{list}) of initial
states to optimize in parallel. Default value: \code{list()}. (i.e., just run a single optimization).}

\item{seed}{integer to seed the random number generator.}

\item{name}{name prefixed to ops created by this function. Default value: \code{NULL}
(i.e., 'build_factored_variational_loss').}
}
\value{
list of:
\itemize{
\item variational_loss: \code{float} \code{Tensor} of shape
\verb{tf$concat([init_batch_shape, model$batch_shape])}, encoding a stochastic
estimate of an upper bound on the negative model evidence \verb{-log p(y)}.
Minimizing this loss performs variational inference; the gap between the
variational bound and the true (generally unknown) model evidence
corresponds to the divergence \code{KL[q||p]} between the approximate and true
posterior.
\item variational_distributions: a named list giving
the approximate posterior for each model parameter. The keys are
\code{character} parameter names in order, corresponding to
\verb{[param.name for param in model.parameters]}. The values are
\code{tfd$Distribution} instances with batch shape
\verb{tf$concat([init_batch_shape, model$batch_shape])}; these will typically be
of the form \code{tfd$TransformedDistribution(tfd.Normal(...), bijector=param.bijector)}.
}
}
\description{
Variational inference searches for the distribution within some family of
approximate posteriors that minimizes a divergence between the approximate
posterior \code{q(z)} and true posterior \code{p(z|observed_time_series)}. By converting
inference to optimization, it's generally much faster than sampling-based
inference algorithms such as HMC. The tradeoff is that the approximating
family rarely contains the true posterior, so it may miss important aspects of
posterior structure (in particular, dependence between variables) and should
not be blindly trusted. Results may vary; it's generally wise to compare to
HMC to evaluate whether inference quality is sufficient for your task at hand.
}
\details{
This method constructs a loss function for variational inference using the
Kullback-Liebler divergence \code{KL[q(z) || p(z|observed_time_series)]}, with an
approximating family given by independent Normal distributions transformed to
the appropriate parameter space for each parameter. Minimizing this loss (the
negative ELBO) maximizes a lower bound on the log model evidence
\verb{-log p(observed_time_series)}. This is equivalent to the 'mean-field' method
implemented in Kucukelbir et al. (2017) and is a standard approach.
The resulting posterior approximations are unimodal; they will tend to underestimate posterior
uncertainty when the true posterior contains multiple modes
(the \code{KL[q||p]} divergence encourages choosing a single mode) or dependence between variables.
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1603.00788}{Alp Kucukelbir, Dustin Tran, Rajesh Ranganath, Andrew Gelman, and David M. Blei. Automatic Differentiation Variational Inference. In \emph{Journal of Machine Learning Research}, 2017.}
}
}

\seealso{
Other sts-functions: 
\code{\link{sts_build_factored_surrogate_posterior}()},
\code{\link{sts_decompose_by_component}()},
\code{\link{sts_decompose_forecast_by_component}()},
\code{\link{sts_fit_with_hmc}()},
\code{\link{sts_forecast}()},
\code{\link{sts_one_step_predictive}()},
\code{\link{sts_sample_uniform_initial_state}()}
}
\concept{sts-functions}
