% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_columns.R
\name{column_categorical_with_vocabulary_list}
\alias{column_categorical_with_vocabulary_list}
\title{Construct a Categorical Column with In-Memory Vocabulary}
\usage{
column_categorical_with_vocabulary_list(
  ...,
  vocabulary_list,
  dtype = NULL,
  default_value = -1L,
  num_oov_buckets = 0L
)
}
\arguments{
\item{...}{Expression(s) identifying input feature(s). Used as the column
name and the dictionary key for feature parsing configs, feature tensors,
and feature columns.}

\item{vocabulary_list}{An ordered iterable defining the vocabulary. Each
feature is mapped to the index of its value (if present) in
\code{vocabulary_list}. Must be castable to \code{dtype}.}

\item{dtype}{The type of features. Only string and integer types are
supported. If \code{NULL}, it will be inferred from \code{vocabulary_list}.}

\item{default_value}{The value to use for values not in \code{vocabulary_list}.}

\item{num_oov_buckets}{Non-negative integer, the number of out-of-vocabulary
buckets. All out-of-vocabulary inputs will be assigned IDs in the range
\verb{[vocabulary_size, vocabulary_size+num_oov_buckets)} based on a hash of the
input value. A positive \code{num_oov_buckets} can not be specified with
\code{default_value}.}
}
\value{
A categorical column with in-memory vocabulary.
}
\description{
Use this when your inputs are in string or integer format, and you have an
in-memory vocabulary mapping each value to an integer ID. By default,
out-of-vocabulary values are ignored. Use \code{default_value} to specify how to
include out-of-vocabulary values. For the input dictionary \code{features},
\code{features$key} is either tensor or sparse tensor object. If it's tensor object,
missing values can be represented by \code{-1} for int and \code{''} for string.
}
\details{
Note that these values are independent of the \code{default_value} argument.
}
\section{Raises}{

\itemize{
\item ValueError: if \code{vocabulary_list} is empty, or contains
duplicate keys.
\item ValueError: if \code{dtype} is not integer or string.
}
}

\seealso{
Other feature column constructors: 
\code{\link{column_bucketized}()},
\code{\link{column_categorical_weighted}()},
\code{\link{column_categorical_with_hash_bucket}()},
\code{\link{column_categorical_with_identity}()},
\code{\link{column_categorical_with_vocabulary_file}()},
\code{\link{column_crossed}()},
\code{\link{column_embedding}()},
\code{\link{column_numeric}()},
\code{\link{input_layer}()}
}
\concept{feature column constructors}
