% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_cumulative.R
\name{h_count_cumulative}
\alias{h_count_cumulative}
\title{Helper function for \code{s_count_cumulative()}}
\usage{
h_count_cumulative(
  x,
  threshold,
  lower_tail = TRUE,
  include_eq = TRUE,
  na_rm = TRUE,
  denom
)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{threshold}{(\code{numeric(1)})\cr a cutoff value as threshold to count values of \code{x}.}

\item{lower_tail}{(\code{flag})\cr whether to count lower tail, default is \code{TRUE}.}

\item{include_eq}{(\code{flag})\cr whether to include value equal to the \code{threshold} in
count, default is \code{TRUE}.}

\item{na_rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{denom}{(\code{string})\cr choice of denominator for proportion. Options are:
\itemize{
\item \code{n}: number of values in this row and column intersection.
\item \code{N_row}: total number of values in this row across columns.
\item \code{N_col}: total number of values in this column across rows.
}}
}
\value{
A named vector with items:
\itemize{
\item \code{count}: the count of values less than, less or equal to, greater than, or greater or equal to a threshold
of user specification.
\item \code{fraction}: the fraction of the count.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper function to calculate count and fraction of \code{x} values in the lower or upper tail given a threshold.
}
\examples{
set.seed(1, kind = "Mersenne-Twister")
x <- c(sample(1:10, 10), NA)
.N_col <- length(x)

h_count_cumulative(x, 5, denom = .N_col)
h_count_cumulative(x, 5, lower_tail = FALSE, include_eq = FALSE, na_rm = FALSE, denom = .N_col)
h_count_cumulative(x, 0, lower_tail = FALSE, denom = .N_col)
h_count_cumulative(x, 100, lower_tail = FALSE, denom = .N_col)

}
\seealso{
\link{count_cumulative}
}
