% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averageandfilterexprs.R
\name{averageandfilterexprs}
\alias{averageandfilterexprs}
\title{Calculate Average Expression and Filter Transcript Data}
\usage{
averageandfilterexprs(expdf, alldf, expthres, showtime = FALSE,
verbose = TRUE)
}
\arguments{
\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{alldf}{A data frame containing all transcript-related information,
including biotype, chromosome, coordinates, transcript, gene,
strand, window, ID and scores retrieved from the bedgraph
files.}

\item{expthres}{A numeric value specifying the expression threshold.
Transcripts with average expression values below this
threshold will be filtered out from the returned transcript
vector.}

\item{showtime}{A logical value indicating if the duration of the function
processing should be indicated before ending. Defaults to
\code{FALSE}.}

\item{verbose}{A logical value indicating whether to print progress messages
Defaults to \code{TRUE}.}
}
\value{
A list containing:
        \item{maintable}{The original data frame containing all transcript
         data.}
        \item{exptranstab}{A character vector of transcripts that meet the
                           filtering criteria.}
}
\description{
This function calculates the average expression levels for transcripts from
a provided expression data frame and filters out transcripts based on a
specified expression threshold. The function also renames the columns in the
output data frame to include mean expression values.
}
\details{
If no transcript is selected as expressed, the function throws an error.
}
\examples{
exppath <-  system.file("extdata", "exptab.csv", package="tepr")
transpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expthres <- 0.1

## Reading tables
expdf <- read.csv(exppath)
transdf <- read.delim(transpath, header = FALSE)

## Testing averageandfilterexprs
resavfilt <- averageandfilterexprs(expdf, transdf, expthres,
       showtime = FALSE, verbose = FALSE)

}
