% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_equi_mcmc.R
\name{multiway_takemura}
\alias{multiway_takemura}
\title{Calculate a truncated multiway Takemura estimator.}
\usage{
multiway_takemura(
  X,
  ortho_max = 2,
  mcmc_itermax = 1000,
  start_identity = FALSE,
  print_mcmc = FALSE,
  mode_rep = NULL
)
}
\arguments{
\item{X}{An array. This is the data array.}

\item{ortho_max}{An integer. The number of 'averagings' to perform.}

\item{mcmc_itermax}{An integer. The number of iterations each MCMC should
perform using \code{equi_mcmc}.}

\item{start_identity}{Should each MCMC start their covariance matrices at the
identity (TRUE) or at the sample covariance matrices (FALSE)?}

\item{print_mcmc}{Should the output of the MCMC be printed to the screen
(TRUE) or not (FALSE)?}

\item{mode_rep}{A vector of integers. Which mode(s) are considered iid
observations? Default is none.}
}
\value{
\code{B} A list of the truncated multiway Takemura's estimators for
  each component covariance matrix. Not their Cholesky square roots.

  \code{b} Truncated multiway Takemura's estimator for the total variation
  parameter. The 'variance' form, not the 'standard devation' form.
}
\description{
This function will 'average' Bayes rules given random rotations of the data
array. This 'averaged' estimator has lower risk than the uniformly minimum
risk equivariant estimator under a product group of lower triangular
matrices. Truncated multiway Takemura's estimator is not equivariant with
respect to this product group of lower triangular matrices, but it is an
equivariant randomized estimator with respect to a product group of
orthogonal matrices.
}
\details{
This function will (1) randomly rotate \code{X} along every mode, then (2) it
will calculate the uniformly minimum risk equivariant estimator using
\code{equi_mcmc}, then (3) it will 'average' these estimates.
}
\examples{
# Simulate data.
p <- c(5, 5, 5)
X <- array(stats::rnorm(prod(p)), dim = p)
multi_out <- multiway_takemura(X, mode_rep = 3)
multi_out$b
trim(multi_out$B[[1]])
trim(multi_out$B[[2]])
trim(multi_out$B[[3]])
}
\references{
\itemize{
  \item{Gerard, D., & Hoff, P. (2015). Equivariant minimax dominators of the MLE in the array normal model. \emph{Journal of Multivariate Analysis}, 137, 32-49. \doi{10.1016/j.jmva.2015.01.020}}
}
}
\seealso{
\code{\link{equi_mcmc}}, \code{\link{random_ortho}}.
}
\author{
David Gerard.
}
\keyword{equivariance}
