% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_ops.R
\name{as_num}
\alias{as_num}
\alias{as_num.default}
\alias{as_num.character}
\alias{as_num.numeric}
\alias{as_num.factor}
\alias{as_num.logical}
\title{Parse text input to numeric vector}
\usage{
as_num(str)

\method{as_num}{default}(str)

\method{as_num}{character}(str)

\method{as_num}{numeric}(str)

\method{as_num}{factor}(str)

\method{as_num}{logical}(str)
}
\arguments{
\item{str}{(\code{vector})\cr to extract numeric from.}
}
\value{
As vector of numeric if directly parsed from \code{numeric} or boolean.
A list of numeric if parsed from a character string, each character string
associated with an list item.
}
\description{
Generic to parse text into numeric vectors. This was initially designed
for a robust interpretation of text input in teal modules.
}
\details{
The function is intended to extract any numeric from a character
string, factor levels, boolean and return a vector of numeric.
}
\examples{
dta <- list(
  character = c("text10,20.5letter30.!", "!-.40$$-50e5[", NA),
  factor    = factor(c("]+60e-6, 7.7\%\%8L", "\%90sep.100\"1L", NA_character_)),
  numeric   = c(1, -5e+2, NA),
  logical   = c(TRUE, FALSE, NA)
)
lapply(dta, as_num)
}
