% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chesmore2001-data.R
\docType{data}
\name{chesmore2001}
\alias{chesmore2001}
\title{Coding Matrix from Chesmore (2001)}
\format{
Matrix
}
\source{
\href{https://phenome.jax.org/projects/Moore1b}{QTL Archive}
}
\usage{
data(chesmore2001)
}
\description{
Coding matrix used for Orthoptera.
}
\examples{
library(tuneR)
wave <- readWave(system.file("extdata", "1.wav", package="tdsc"))
data(chesmore2001)
t <- tdsc(wave, coding_matrix=chesmore2001)
}
\references{
Chesmore, E David (2001). “Application of time domain signal coding and artificial neural networks to passive acoustical identification of animals”. In: Applied Acoustics 62.12, pp. 1359–1374.
}
\keyword{CodingMatrix}
\keyword{TDSC}
