% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve_names.R
\name{resolve_names}
\alias{resolve_names}
\title{Resolve canonical names against GNA}
\usage{
resolve_names(
  taxolist,
  sciname = "canonical",
  score_threshold = 0.98,
  best_match_only = TRUE,
  add_fields = NA,
  verbose = TRUE
)
}
\arguments{
\item{taxolist}{(data frame) taxonomic list}

\item{sciname}{() column name for scientific names}

\item{score_threshold}{(numeric) to make sure names match as desired. 
Default (0.98)
Higher value indicates best match, lower values would return matches at 
genus level}

\item{best_match_only}{(logical) If TRUE, best match only returned else 
return all records returned by GNA. Default: TRUE}

\item{add_fields}{(character) One of NA (default) , minimal or all. NA adds a 
logical column 'resolved', Minimal gives back just four fields, whereas all 
gives all fields back.}

\item{verbose}{(logical) verbose output, Default: FALSE}
}
\value{
(data frame) names list resolves
}
\description{
Resolve names against Global Names Architecture (GNA) to make sure the name
exists
}
\examples{
\donttest{
mylist <- data.frame("canonical" = c("Abrothrix longipilis",
                                     "Acodon hirtus",
                                     "Akodon longipilis apta",
                                     "AKODON LONGIPILIS CASTANEUS",
                                     "Chroeomys jelskii",
                                     "Acodon jelskii pyrrhotis"),
                     stringsAsFactors = FALSE)
test <- resolve_names(mylist)
test1 <- resolve_names(mylist,add_fields = "minimal")
test2 <- resolve_names(mylist,best_match_only = FALSE,add_fields = "minimal")
test3 <- resolve_names(mylist,best_match_only = FALSE,add_fields = "all")
}
}
\seealso{
Other Name functions: 
\code{\link{build_gen_syn}()},
\code{\link{cast_canonical}()},
\code{\link{cast_scientificname}()},
\code{\link{check_scientific}()},
\code{\link{expand_name}()},
\code{\link{get_accepted_names}()},
\code{\link{guess_taxo_rank}()},
\code{\link{list_higher_taxo}()},
\code{\link{melt_canonical}()},
\code{\link{melt_scientificname}()},
\code{\link{taxo_fuzzy_match}()}
}
\concept{Name functions}
