% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune_levels.R
\name{prune_levels}
\alias{prune_levels}
\alias{prune_levels.taxlist}
\alias{prune_levels,taxlist-method}
\title{Prune not used taxonomic ranks}
\usage{
prune_levels(object, ...)

\method{prune_levels}{taxlist}(object, ...)
}
\arguments{
\item{object}{An object of class \linkS4class{taxlist}.}

\item{...}{Further arguments passed among methods (not yet in use).}
}
\value{
An object of class \linkS4class{taxlist} with pruned taxonomic ranks.
}
\description{
Taxonomic ranks without taxon concepts will be pruned in \linkS4class{taxlist}
objects.
}
\examples{
## Subset species belonging to Cyperus
Cyperus <- subset(Easplist, TaxonName == "Cyperus", slot = "taxonNames",
    keep_children = TRUE, keep_parents = TRUE)
Cyperus

## Prune not used ranks
prune_levels(Cyperus)
}
\seealso{
\link[=levels]{levels()}
}
