% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_rows.R
\name{insert_rows}
\alias{insert_rows}
\alias{insert_rows,data.frame,data.frame-method}
\title{Insert additional rows to a data frame.}
\usage{
insert_rows(x, y, ...)

\S4method{insert_rows}{data.frame,data.frame}(x, y, ...)
}
\arguments{
\item{x}{A data frame.}

\item{y}{A data frame including rows (and columns) to be inserted in \code{x}.}

\item{...}{Addicional arguments passed among methods.}
}
\value{
A data frame.
}
\description{
Adding new rows from data frame sharing some columns.
Data contained in \code{y} is assumed to be additional data and will be
appended.

Columns occurring in only one of the data frames will be added to the output.
}
\examples{
## Merge data frames including new columns
data(iris)
iris$Species <- paste(iris$Species)
new_iris <- data.frame(Species = rep("humilis", 2), Height = c(15, 20),
    stringsAsFactors = FALSE)
insert_rows(iris, new_iris)
}
