% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_authority.R
\name{taxon_authority}
\alias{taxon_authority}
\title{Taxon authority class}
\usage{
taxon_authority(
  author = character(),
  date = "",
  citation = "",
  .names = "",
  extract_date = TRUE
)
}
\arguments{
\item{author}{Zero or more author names.}

\item{date}{Zero or more dates.}

\item{citation}{Zero or more literature citations.}

\item{.names}{The names of the vector.}

\item{extract_date}{If \code{TRUE} (the default), then if a date is detected in the \code{author} input and
no \code{date} input is given, then the date is separated from the author input.}
}
\value{
An \code{S3} object of class \code{taxa_taxon_authority}
}
\description{
\Sexpr[results=rd, stage=render]{taxa:::lifecycle("maturing")} Used to store information on taxon authorities, such as author names, date, and citation.
}
\examples{

# Making new objects
x <- taxon_authority(c('A', 'B', 'C'))
x <- taxon_authority(c('Cham. & Schldl.', 'L.'),
                     date = c('1827', '1753'))

# Manipulating objects
as.character(x)
x[2]
x[2] <- 'ABC'
names(x) <- c('a', 'b')
x['b'] <- 'David Bowie'
tax_author(x)[1] <- tolower(tax_author(x)[1])
tax_author(x)
tax_date(x) <- c('2000', '1234')
tax_date(x)
tax_cite(x)[2] <- c('Linnaeus, C. (1771). Mantissa plantarum altera generum.')
tax_cite(x)

# Using as columns in tables
tibble::tibble(x = x, y = 1:2)
data.frame(x = x, y = 1:2)

# Converting to tables
tibble::as_tibble(x)
as_data_frame(x)

}
\seealso{
Other classes: 
\code{\link{[.taxa_classification}()},
\code{\link{classification}()},
\code{\link{taxon}()},
\code{\link{taxon_db}()},
\code{\link{taxon_id}()},
\code{\link{taxon_rank}()}
}
\concept{classes}
