% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{parse.abbrev.render.code}
\alias{parse.abbrev.render.code}
\title{Parse abbreviated code for rendering table output.}
\usage{
parse.abbrev.render.code(code, ...)
}
\arguments{
\item{code}{A \code{character} vector specifying the statistics to display
in abbreviated code. See Details.}

\item{...}{Further arguments, passed to \code{\link{stats.apply.rounding}}.}
}
\value{
A function that takes a single argument and returns a
\code{character} vector.
}
\description{
Parse abbreviated code for rendering table output.
}
\details{
In abbreviated code, the words N, NMISS, MEAN, SD, MIN, MEDIAN,
MAX, IQR, CV, GMEAN, GSD, GCV, FREQ and PCT are substituted for their respective
values (see \code{\link{stats.default}}). The substitution is case
insensitive, and the substituted values are rounded appropriately (see
\code{\link{stats.apply.rounding}}). Other text is left unchanged. The
\code{code} can be a vector, in which case each element is displayed in its
own row in the table. The \code{names} of \code{code} are used as row
labels; if no names are present, then the \code{code} itself is used unless
\code{code} is of length 1, in which case no label is used (for numeric
variables only, categorical variables are always labeled by the class
label). The special name '.' also indicates that \code{code} itself be is
used as the row label.
}
\examples{
\dontrun{
x <- round(exp(rnorm(100, log(20), 1)), 2)
stats.default(x)
f <- parse.abbrev.render.code(c("Mean (SD)", "Median [Min, Max]"), 3)
f(x)
f2 <- parse.abbrev.render.code(c("Geo. Mean (Geo. CV\%)" = "GMean (GCV\%)"), 3)
f2(x)
f3 <- parse.abbrev.render.code(c("Mean (SD)"), 3)
f3(x)

x <- sample(c("Male", "Female"), 30, replace=T)
stats.default(x)
f <- parse.abbrev.render.code("Freq (Pct\%)")
f(x)
}

}
\keyword{utilities}
