% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svine.R
\name{svine_dist}
\alias{svine_dist}
\title{Custom S-vine distribution models}
\usage{
svine_dist(margins, copula)
}
\arguments{
\item{margins}{A list of length \code{d} containing \code{univariateML} objects.}

\item{copula}{the copula model; an object of class \code{svinecop_dist} with
cross-sectional dimension \code{d}.}
}
\value{
Returns the model as an object with class  \code{svine_dist}.
A list with entries
\itemize{
\item \verb{$margins}: list of marginal models from \link[univariateML:univariateML_models]{univariateML::univariateML_models},
\item \verb{$copula}: an object of \code{svinecop_dist}.
}
}
\description{
Custom S-vine distribution models
}
\examples{
## marginal objects
# create dummy univariateML models
univ1 <- univ2 <- univariateML::mlnorm(rnorm(10))

# modify the parameters to N(5, 10) and N(0, 2) distributions
univ1[] <- c(5, 10)
univ2[] <- c(0, 2)

## copula óbject
cs_struct <- cvine_structure(1:2)
pcs <- list(
  list(  # first tree
    bicop_dist("clayton", 0, 3), # cross sectional copula
    bicop_dist("gaussian", 0, -0.1)  # serial copula
  ),
  list(  # second tree
    bicop_dist("gaussian", 0, 0.2), bicop_dist("indep")  
  ),
  list( # third tree
    bicop_dist("indep")
  )
)

cop <- svinecop_dist(
  pcs, cs_struct, p = 1, out_vertices = 1:2, in_vertices = 1:2)
    
model <- svine_dist(margins = list(univ1, univ2), copula = cop)
summary(model)

}
\seealso{
\link{svine_dist}, \link{svine_loglik}, \link{svine_sim}, \link{svine_bootstrap_models}
}
