% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.survregVB.R
\name{summary.survregVB}
\alias{summary.survregVB}
\alias{print.summary.survregVB}
\title{Summary for Variational Bayes log-logistic AFT models.}
\usage{
\method{summary}{survregVB}(object, ci = 0.95, ...)
}
\arguments{
\item{object}{The result of a \code{survregVB} fit.}

\item{ci}{The significance level for the credible intervals. (Default:0.95).}

\item{\dots}{For future arguments.}
}
\value{
An object of class \code{summary.survregVB} with components:
\itemize{
\item \code{ELBO}: The final value of the Evidence Lower Bound (ELBO)
at the last iteration.
\item \code{alpha}: The shape parameter \eqn{\alpha^*} of \eqn{q^*(b)}.
\item \code{omega}: The scale parameter \eqn{\omega^*} of \eqn{q^*(b)}.
\item \code{mu}: Parameter \eqn{\mu^*} of \eqn{q^*(\beta)}, a vector
of means.
\item \code{Sigma}: Parameter \eqn{\Sigma^*} of \eqn{q^*(\beta)}, a
covariance matrix.
\item \code{na.action}: A missing-data filter function, applied to the
\code{model.frame}, after any subset argument has been used.
\item \code{iterations}: The number of iterations performed by the VB
algorithm: before converging or reaching \code{max_iteration}.
\item \code{n}: The number of observations.
\item \code{call}: The function call used to invoke the \code{survregVB}
method.
\item \code{not_converged}: A boolean indicating if the algorithm
converged.
\itemize{
\item \code{TRUE}: If the algorithm did not converge prior to
achieving \code{max_iteration}.
\item \code{NULL}: If the algorithm converged successfully.
}
\item \code{estimates}: A matrix with one row for each regression coefficient,
and one row for the scale parameter. The columns contain:
\itemize{
\item \code{Value}: The estimated value based on the posterior
distribution mean.
\item \code{Lower CI}: The lower bound of the credible interval.
\item \code{Upper CI}: The upper bound of the credible interval.
}
}

If called with shared frailty, the object also contains components:
\itemize{
\item \code{lambda}: The shape parameter \eqn{\lambda^*} of
\eqn{q^*(\sigma^2_\gamma)}.
\item \code{eta}: The scale parameter \eqn{\eta^*} of
\eqn{q^*(\sigma^2_\gamma)}.
\item \code{tau}: Parameter \eqn{\tau^*_i} of \eqn{q^*(\gamma_i)}, a
vector of means.
\item \code{sigma}: Parameter \eqn{\sigma^{2*}_i} of \eqn{q^*(\gamma_i)},
a vector of variance.
}
The \code{estimates} component will contain an additional row for the
frailty, the estimated variance based on the posterior mean for the
random intercepts.
}
\description{
Produces a summary of a fitted Variational Bayes Parametric Survival
Regression Model for a Log-Logistic AFT Model
}
\seealso{
\code{\link{survregVB}}
}
