% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{sd_include_folder}
\alias{sd_include_folder}
\title{Include a folder to the 'shiny' resource path}
\usage{
sd_include_folder(folder)
}
\arguments{
\item{folder}{A character string specifying the name of the folder to
include. This folder should exist in the root directory of your 'shiny'
app.}
}
\value{
\code{NULL} invisibly. The function is called for its side effect of
adding a resource path to 'shiny'.
}
\description{
This function includes a specified folder to the 'shiny' resource path,
making it accessible for serving static files in a 'shiny' application.
It checks for pre-existing resource paths to avoid conflicts with
folders already included by the package.
}
\examples{
if (interactive()) {
  library(shiny)

  # Create an "images" folder
  dir.create("images")

  # Include the folder in the shiny resource path
  sd_include_folder("images")
}

}
