% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_replace.R
\name{str_replace_all}
\alias{str_replace_all}
\title{Replace matched patterns in a string}
\source{
Adapted from the \href{https://stringr.tidyverse.org/}{stringr} package.
}
\usage{
str_replace_all(string, pattern, replacement)
}
\arguments{
\item{string}{Input vector.
Either a character vector, or something coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression,
as described in \link[base:regex]{base::regex}.
Control options with \code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using \code{\link[=fixed]{fixed()}}.
This is fast, but approximate.}

\item{replacement}{A character vector of replacements.
Should be either length one, or the same length as \code{string} or \code{pattern}.
References of the form \verb{\\1}, \verb{\\2}, etc. will be replaced with the contents
of the respective matched group (created by \verb{()}).

To perform multiple replacements in each element of \code{string},
pass a named vector \code{(c(pattern1 = replacement1))} to \code{str_replace_all()}.

To replace the complete string with \code{NA},
use \code{replacement = NA_character_}.

Using a function for \code{replacement} is not yet supported.}
}
\value{
A character vector.
}
\description{
Dependency-free drop-in alternative for \code{stringr::str_replace_all()}.
}
