% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_enrich_dimension.R
\name{enrich_dimension_import_test}
\alias{enrich_dimension_import_test}
\alias{enrich_dimension_import_test.star_schema}
\title{Import \code{tibble} to test to enrich a dimension}
\usage{
enrich_dimension_import_test(st, name = NULL, tb)

\method{enrich_dimension_import_test}{star_schema}(st, name = NULL, tb)
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{name}{A string, name of the dimension.}

\item{tb}{A \code{tibble} object.}
}
\value{
A \code{dimension} object.
}
\description{
For a dimension of a star schema a \code{tibble} is attached. This contains
dimension attributes and new attributes. If values associated with all rows
in the dimension are included in the \code{tibble}, the dimension is enriched with
the new attributes. This function checks that there are values for all
instances. Returns the dimension instances that do not match the imported
data.
}
\examples{

tb <-
  enrich_dimension_export(st_mrs_age,
                          name = "when_common",
                          attributes = c("week", "year"))

# Add new columns with meaningful data (these are not), possibly exporting
# data to a file, populating it and importing it.
tb <- tibble::add_column(tb, x = "x", y = "y", z = "z")[-1, ]

tb2 <- enrich_dimension_import_test(st_mrs_age, name = "when_common", tb)

}
\seealso{
Other dimension enrichment functions: 
\code{\link{enrich_dimension_export}()},
\code{\link{enrich_dimension_import}()}
}
\concept{dimension enrichment functions}
