% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constellation_as_tibble_list.R
\name{constellation_as_tibble_list}
\alias{constellation_as_tibble_list}
\alias{constellation_as_tibble_list.constellation}
\title{Export a constellation as a \code{tibble} list}
\usage{
constellation_as_tibble_list(ct, include_role_playing = FALSE)

\method{constellation_as_tibble_list}{constellation}(ct, include_role_playing = FALSE)
}
\arguments{
\item{ct}{A \code{constellation} object.}

\item{include_role_playing}{A boolean.}
}
\value{
A list of \code{tibble} objects.
}
\description{
Once we have refined the format or content of facts and dimensions, we can
obtain a \code{tibble} list with them. Role playing dimensions can be optionally
included.
}
\examples{

tl <- ct_mrs |>
  constellation_as_tibble_list()

tl <- ct_mrs |>
  constellation_as_tibble_list(include_role_playing = TRUE)

}
\seealso{
Other results export functions: 
\code{\link{constellation_as_multistar}()},
\code{\link{multistar_as_flat_table}()},
\code{\link{star_schema_as_flat_table}()},
\code{\link{star_schema_as_multistar}()},
\code{\link{star_schema_as_tibble_list}()}
}
\concept{results export functions}
