% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_dilution}
\alias{eem_dilution}
\title{Modifying fluorescence data according to dilution.}
\usage{
eem_dilution(data, dilution = 1)
}
\arguments{
\item{data}{fluorescence data with class eemlist}

\item{dilution}{dilution factor(s), either numeric value or data frame. Row names of data frame have to be similar to sample names in eemlist.}
}
\value{
fluorescence data with class eemlist
}
\description{
If samples were diluted before measuring, a dilution factor has to be added to the measured data. This function can do that by either multilpying each sample with the same value or using a data frame with different values for each sample.
}
\examples{
data(eem_list)

eem_list2 <- eem_dilution(eem_list, dilution = 5)

dilutionT <- data.frame(dilution = rep(5, length(eem_list)))
row.names(dilutionT) <- eem_names(eem_list)
dilutionT

eem_list3 <- eem_dilution(eem_list, dilution = dilutionT)

}
