% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunks_of_n.R
\name{chunks_of_n}
\alias{chunks_of_n}
\title{MOVED Split to chunks of size n}
\usage{
chunks_of_n(d, n, label = NULL, even = FALSE, pattern = NULL)
}
\arguments{
\item{d}{data. Can be vector or data frame.}

\item{n}{number of chunks}

\item{label}{naming prefix for chunk names}

\item{even}{boolean to set if size of chunks should be evenly distributed.}

\item{pattern}{regex pattern to extract names from provided vector. If data
frame, will assume first column is name.}
}
\value{
List of length n
}
\description{
MOVED Split to chunks of size n
}
\examples{
tail(chunks_of_n(seq_len(100),7),3)
tail(chunks_of_n(seq_len(100),7,even=TRUE),3)
ds <- data.frame(nm=paste0("Sub",
add_padding(rownames(stRoke::talos))),stRoke::talos)
head(chunks_of_n(ds,7,pattern="Sub[0-9]{3}",label="grp"),2)
## Please notice that no sorting is performed. This is on purpose to preserve
## original sorting. If sorting is intended, try something like this:
ds[order(ds$nm),] |> chunks_of_n(7,pattern="Sub[0-9]{3}",label="grp") |> 
head(2)
}
