% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssd-plot.R
\name{ssd_plot}
\alias{ssd_plot}
\title{Plot Species Sensitivity Data and Distributions}
\usage{
ssd_plot(
  data,
  pred,
  left = "Conc",
  right = left,
  ...,
  label = NULL,
  shape = NULL,
  color = NULL,
  size,
  linetype = NULL,
  linecolor = NULL,
  xlab = "Concentration",
  ylab = "Species Affected",
  ci = TRUE,
  ribbon = TRUE,
  hc = 0.05,
  shift_x = 3,
  add_x = 0,
  bounds = c(left = 1, right = 1),
  big.mark = ",",
  suffix = "\%",
  trans = "log10",
  xbreaks = waiver(),
  xlimits = NULL,
  text_size = 11,
  label_size = 2.5,
  theme_classic = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{pred}{A data frame of the predictions.}

\item{left}{A string of the column in data with the concentrations.}

\item{right}{A string of the column in data with the right concentration values.}

\item{...}{Unused.}

\item{label}{A string of the column in data with the labels.}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{color}{A string of the column in data for the color aesthetic.}

\item{size}{A number for the size of the labels. Deprecated for \code{label_size}. #' \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{linetype}{A string of the column in pred to use for the linetype.}

\item{linecolor}{A string of the column in pred to use for the line color.}

\item{xlab}{A string of the x-axis label.}

\item{ylab}{A string of the x-axis label.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by bootstrapping).}

\item{ribbon}{A flag indicating whether to plot the confidence interval as a grey ribbon as opposed to green solid lines.}

\item{hc}{A value between 0 and 1 indicating the proportion hazard concentration (or NULL).}

\item{shift_x}{The value to multiply the label x values by (after adding \code{add_x}).}

\item{add_x}{The value to add to the label x values (before multiplying by \code{shift_x}).}

\item{bounds}{A named non-negative numeric vector of the left and right bounds for
uncensored missing (0 and Inf) data in terms of the orders of magnitude
relative to the extremes for non-missing values.}

\item{big.mark}{A string specifying used between every 3 digits to separate thousands on the x-axis.}

\item{suffix}{Additional text to display after the number on the y-axis.}

\item{trans}{A string of which transformation to use. Accepted values include \code{"log10"}, \code{"log"}, and \code{"identity"} (\code{"log10"} by default).}

\item{xbreaks}{The x-axis breaks as one of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks
\item A numeric vector of positions
}}

\item{xlimits}{The x-axis limits as one of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing the limits.
Use NA to refer to the existing minimum or maximum limits.
}}

\item{text_size}{A number for the text size.}

\item{label_size}{A number for the size of the labels.}

\item{theme_classic}{A flag specifying whether to use the classic theme or the default.}
}
\description{
Plots species sensitivity data and distributions.
}
\examples{
ssd_plot(ssddata::ccme_boron, boron_pred, label = "Species", shape = "Group")
}
\seealso{
\code{\link[=ssd_plot_cdf]{ssd_plot_cdf()}} and \code{\link[=geom_ssdpoint]{geom_ssdpoint()}}
}
