% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_grouped_plots.R
\name{group_cdf_censored}
\alias{group_cdf_censored}
\title{Graphical representation of grouped toxicity censored data}
\usage{
group_cdf_censored(fits, unit, logscale, data)
}
\arguments{
\item{fits}{A list of fits of class \code{fitdist} or \code{fitdistcens}
computed from the same toxicity data.}

\item{unit}{A character vector, the unit of the toxicity data}

\item{logscale}{if \code{TRUE}, uses a logarithmic scale for the \eqn{x}-axis}

\item{data}{A data.frame with columns \code{left}, \code{right} and
\code{group}}
}
\value{
A ggplot object.
}
\description{
Create an empirical cdf representation colored according to a "group"
attribute. The fitted distribution is also represented.
}
\details{
The plot represents each interval of toxicity values with a horizontal line,
or a point if the bounds of the interval are equal, using function
\code{cens_lines_plot()}.
}
