% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_squids.R, R/squids.R
\name{random_squids}
\alias{random_squids}
\alias{squids}
\title{Generate short quasi-unique identifiers (SQUIDs)}
\usage{
random_squids(x, origin = Sys.time(), follow = NULL, followBy = NULL)

squids(x, origin = Sys.time(), follow = NULL, followBy = NULL)
}
\arguments{
\item{x}{The number of identifiers to generate.}

\item{origin}{The origin to use when generating the SQUIDs. This allows
you to reproduce the same sequence of SQUIDs. You can easily get an
origin with \code{\link[=get_current_origin]{get_current_origin()}}. The \code{origin} is a timestamp;
an object of class \code{POSIXct} (see \link{squids-package} for more
details).}

\item{follow}{A vector of one or more SQUIDs (or a list; lists are
recursively \code{unlist()}ed); the highest SQUID will be taken, converted
to a timestamp, and used as \code{origin} (well, 0.01 second later), so that the
new SQUIDs will follow that sequence.}

\item{followBy}{When following a vector of SQUIDs, this can be used to
specify the distance between the two vectors in centiseconds.}
}
\value{
A vector of SQUIDs.
}
\description{
The \code{squids::squids()} function generates a sequence of short quasi-unique
identifiers (see \link{squids-package} for more details).
The \code{squids::random_squids()} function is a convenience function that
randomizes the result before returning it.
}
\details{
SQUIDs are defined as 8-character strings that express a timestamp (the
number of centiseconds that passed since the UNIX Epoch) in a base 30
decimal system. The lowest possible SQUID is \code{00000001} (which
corresponds to 1970-01-01 00:00:00 UTC), and the highest possible SQUID is
\code{zzzzzzzz}, which corresponds to 2177-11-28 11:59:59 UTC. More details
are in the \link{squids-package} manual page.
}
\examples{
exampleSQUIDs <-
  squids::squids(5);

### Show how SQUIDs are the converted date/time
squids::squids_to_datetime(
  exampleSQUIDs
);

### These seem the same, but if we take these as
### timestamps (seconds passed since the UNIX Epoch)
### and multiply with 100 to see the centiseconds,
### we see the differences:
as.numeric(
  squids::squids_to_datetime(
    exampleSQUIDs
  )
) * 100;

### Get a sequence following the first one
squids::squids(5, follow=exampleSQUIDs);

### Follow at a distance
squids::squids(
  5,
  follow=exampleSQUIDs,
  followBy = 3
);
}
