#' Convert an origin (a timestamp) to a SQUID
#'
#' For convenience, `origin_to_squids()`, `datetime_to_squids()`, and
#' `POSIXt_to_squids()` can all be used (i.e. they're aliases for the same
#' function). For more information, see [squids::squids()]. For conversion
#' the other way around, see [squids::squids_to_origin()].
#'
#' @param x The time, e.g. `Sys.time()`.
#'
#' @returns A SQUID
#' @export origin_to_squids
#' @export datetime_to_squids
#' @export POSIXt_to_squids
#'
#' @examples squids::origin_to_squids(
#'   Sys.time()
#' );
#' @aliases origin_to_squids datetime_to_squids POSIXt_to_squids
origin_to_squids <- datetime_to_squids <- POSIXt_to_squids <- function(x) {

  if (is.null(x) || all(is.na(x))) {
    return(x);
  }

  if (!inherits(x, "POSIXt")) {
    stop("As `x`, you have to pass a time (a `POSIXt` object). You passed a vector of ",
         "class ", vecTxt(class(x)), ".");
  }

  timeNrString <- round(as.numeric(x) * 100, 0);

  res <-
    unlist(lapply(timeNrString,
                  numericToBase30));

  class(res) <- c("squids", class(res));

  return(res);

}
